package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SymmetricAlgorithmImpl.SymmAlgorithm;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SymmetricAlgorithmImpl extends EnumMapping<SymmAlgorithm> {

	public enum SymmAlgorithm {
		AES_128_CCM(128);

		private final int keyLength;

		SymmAlgorithm(int keyLength) {
			this.keyLength = keyLength;
		}

		public int getKeyLength() {
			return keyLength;
		}

	}

	private static SymmetricAlgorithmImpl instance;

	private SymmetricAlgorithmImpl() {
	}

	public static SymmetricAlgorithmImpl getInstance() {
		if (instance == null)
			instance = new SymmetricAlgorithmImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, SymmAlgorithm> map) {
		map.put(0, SymmAlgorithm.AES_128_CCM);
	}

}
