/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectTypeImpl.SubjectType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class SubjectTypeImpl extends EnumMapping<SubjectType> {

	public enum SubjectType {

		ENROLLMENT_CREDENTIAL, AUTHORIZATION_TICKET, AUTHORIZATION_AUTHORITY, ENROLLMENT_AUTHORITY, ROOT_CA, CRL_SIGNER;

	}

	private static SubjectTypeImpl instance = null;

	private SubjectTypeImpl() {
	}

	public static SubjectTypeImpl getInstance() {
		if (instance == null)
			instance = new SubjectTypeImpl();

		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, SubjectType> map) {
		map.put(0, SubjectType.ENROLLMENT_CREDENTIAL);
		map.put(1, SubjectType.AUTHORIZATION_TICKET);
		map.put(2, SubjectType.AUTHORIZATION_AUTHORITY);
		map.put(3, SubjectType.ENROLLMENT_AUTHORITY);
		map.put(4, SubjectType.ROOT_CA);
		map.put(5, SubjectType.CRL_SIGNER);
	}

}
