package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 *
 */
public class SpeedWithConfidence extends WaveElement {

	// ---- fields ----

	@Internal(order = 0)
	private SInt32 speed;

	@Internal(order = 1)
	private UInt8 confidence;

	// ---- fields ----

	// ---- constructors ----

	public SpeedWithConfidence() {
	}

	public SpeedWithConfidence(DataInputStream in) throws IOException {
		speed = new SInt32(in);
		confidence = new UInt8(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public SInt32 getSpeed() {
		return this.speed;
	}

	public UInt8 getConfidence() {
		return this.confidence;
	}

	// ---- setter ----

	public void setSpeed(SInt32 speed) {
		this.speed = speed;
	}

	public void setConfidence(UInt8 confidence) {
		this.confidence = confidence;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (speed == null || confidence == null) {
			throw new IllegalArgumentException();
		}
		int written = 0;
		written += speed.writeData(out);
		written += confidence.writeData(out);
		return written;
	}
}