package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.ca.utils.WaveUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class SecuredMessage extends WaveElement {

	private UInt8 protocolVersion = new UInt8(1); // Default value: 1
	private UInt8 securityProfile = new UInt8(0); // Default value: 0
	private HeaderField[] headerFields;
	private Payload[] payloadFields;
	private TrailerField[] trailerFields;

	public SecuredMessage() {
	}

	public SecuredMessage(DataInputStream in) throws IOException {
		protocolVersion = new UInt8(in);
		securityProfile = new UInt8(in);
		headerFields = WaveUtils.getArrayFromStream(in, HeaderField.class);
		payloadFields = WaveUtils.getArrayFromStream(in, Payload.class);
		trailerFields = WaveUtils.getArrayFromStream(in, TrailerField.class);
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public UInt8 getProtocolVersion() {
		return protocolVersion;
	}

	public HeaderField[] getHeaderFields() {
		return headerFields;
	}

	public Payload[] getPayloadFields() {
		return payloadFields;
	}

	public TrailerField[] getTrailerFields() {
		return trailerFields;
	}

	public UInt8 getSecurityProfile() {
		return securityProfile;
	}

	public void setSecurityProfile(UInt8 securityProfile) {
		this.securityProfile = securityProfile;
	}

	public void setProtocolVersion(UInt8 protocolVersion) {
		this.protocolVersion = protocolVersion;
	}

	public void setHeaderFields(HeaderField[] headerFields) {
		this.headerFields = headerFields;
	}

	public void setPayloadFields(Payload[] payloadFields) {
		this.payloadFields = payloadFields;
	}

	public void setTrailerFields(TrailerField[] securityFields) {
		this.trailerFields = securityFields;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		int written = WaveUtils.writeWave(out, protocolVersion);
		written += WaveUtils.writeWave(out, securityProfile);
		written += WaveUtils.writeArrayToStream(out, headerFields);
		written += WaveUtils.writeArrayToStream(out, payloadFields);
		written += WaveUtils.writeArrayToStream(out, trailerFields);
		return written;
	}

}
