package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SInt32 extends UInt16 {

	public SInt32(int val) {
		super(val);
	}

	public SInt32(DataInputStream in) throws IOException {
		super(in);
	}
	
	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit((SInt32) this);
	}

	@Override
	public void set(int data) {
		this.data = data;
	}

	@Override
	protected void set(DataInputStream in) throws IOException {
		this.data = in.readInt();
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {

		out.writeInt(this.data);
		return 4;
	}

}
