package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.RegionDictionaryImpl.RegionDictionary;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class RegionDictionaryImpl extends EnumMapping<RegionDictionary> {

	public enum RegionDictionary {

		ISO_3166_1(0),
		UN_STATS(1);
		
		private byte type;
		
		RegionDictionary(int type) {
			this.type = (byte) (0xFF & type);
		}
		
		public byte getType() {
			return this.type;
		}
		
		public int getNumber() {
			int i = type;
			i &= 0xFF;
			return i;
		}
	}
	
	// singleton - to avoid multiple initialization
	private static RegionDictionaryImpl instance = null;

	private RegionDictionaryImpl() {
		writtenBytelength = 1;
	}

	public static RegionDictionaryImpl getInstance() {
		if (instance == null)
			instance = new RegionDictionaryImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, RegionDictionary> map) {
		map.put(0, RegionDictionary.ISO_3166_1);
		map.put(1, RegionDictionary.UN_STATS);
	}

}
