package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.PayloadTypeImpl.PayloadType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class PayloadTypeImpl extends EnumMapping<PayloadType> {

	public enum PayloadType {
		UNSECURED, SIGNED, ENCRYPTED, SIGNED_EXTERNAL, SIGNED_AND_ENCRYPTED;
	}

	private static PayloadTypeImpl instance = null;

	private PayloadTypeImpl() {
	}

	public static PayloadTypeImpl getInstance() {
		if (instance == null)
			instance = new PayloadTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, PayloadType> map) {
		map.put(0, PayloadType.UNSECURED);
		map.put(1, PayloadType.SIGNED);
		map.put(2, PayloadType.ENCRYPTED);
		map.put(3, PayloadType.SIGNED_EXTERNAL);
		map.put(4, PayloadType.SIGNED_AND_ENCRYPTED);
	}

}
