package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class HashedId8 extends WaveElement {

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((hashedid8 == null) ? 0 : hashedid8.hashCode());
		return result;
	}

	@Internal(order = 0)
	private Opaque hashedid8;

	public HashedId8() {
	}

	public HashedId8(DataInputStream in) throws IOException {
		hashedid8 = new Opaque(in, 8, true);
	}

	public HashedId8(byte[] bs) {
		hashedid8 = new Opaque(bs, 8, true);
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public Opaque getCertID() {
		return hashedid8;
	}
	
	public String getCertIdHex() {
		return Hex.encodeHexString(hashedid8.get());
	}

	public void set(Opaque hashedid8) {
		this.hashedid8 = hashedid8;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (hashedid8 == null)
			throw new IllegalArgumentException();
		if (!hashedid8.isArray() || hashedid8.getLength() != 8)
			throw new IllegalArgumentException();
		return hashedid8.writeData(out);
	}
	
	public static HashedId8 generateFromCertificate(byte[] certData) {
		try {
			MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
			byte[] digest = sha256.digest(certData);
			byte[] hashedID8 = new byte[8];
			System.arraycopy(digest, digest.length - 8, hashedID8, 0, hashedID8.length);
			HashedId8 id = new HashedId8();
			Opaque o = new Opaque();
			o.set(hashedID8);
			id.set(o);
			return id;
		} catch (NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

}
