package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class HashedId3 extends WaveElement {

	@Internal(order = 0)
	private Opaque hashedId3;

	public HashedId3(DataInputStream in) throws IOException {
		hashedId3 = new Opaque(in, 3, true);
	}
	
	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public Opaque get() {
		return this.hashedId3;
	}

	public void set(Opaque hasehdId2) {
		this.hashedId3 = hasehdId2;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (hashedId3 == null)
			throw new IllegalArgumentException();
		if (!hashedId3.isArray() || hashedId3.getLength() != 3)
			throw new IllegalArgumentException();
		return hashedId3.writeData(out);
	}

}