package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

public class CircularRegion extends WaveElement implements
		de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.CircularRegion {

	// ---- fields ----

	@Internal(order = 0)
	private TwoDLocation center;

	@Internal(order = 1)
	private UInt16 radius;

	// ---- fields ----

	// ---- constructors ----

	public CircularRegion(DataInputStream in) throws IOException {

		this.center = new TwoDLocation(in);
		this.radius = new UInt16(in);
	}

	public CircularRegion(TwoDLocation center, UInt16 radius) {
		super();
		this.center = center;
		this.radius = radius;
	}

	public CircularRegion(BigInteger latitude, BigInteger longitude, BigInteger radius) {
		super();
		this.center = new TwoDLocation(latitude.intValue(), longitude.intValue());
		this.radius = new UInt16(radius.intValue());
	}

	public CircularRegion() {
		super();
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public TwoDLocation getCenter() {
		return this.center;
	}

	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation getICenter() {
		return this.center;
	}

	public UInt16 getRadius() {
		return this.radius;
	}

	// ---- setter ----

	public void setCenter(TwoDLocation center) {
		this.center = center;
	}

	public void setRadius(UInt16 radius) {
		this.radius = radius;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (center == null || radius == null)
			throw new IllegalArgumentException("args may not be null");

		int written = 0;
		written += center.writeData(out);
		written += radius.writeData(out);
		return written;
	}

	@Override
	public int getRadiusInt() {
		return this.radius.get();
	}

	@Override
	public String toString() {
		if (radius != null)
			return "CircularRegion [center=" + center + ", radius=" + radius.get() + "]";
		else
			return "CircularRegion [center=" + center + ", radius=" + radius + "]";
	}
}