package de.fraunhofer.sit.c2x.test;

import static org.junit.Assert.assertTrue;

import java.util.Random;

import org.junit.Test;

import de.fraunhofer.sit.c2x.CryptoLib;
import de.fraunhofer.sit.c2x.EcdsaP256KeyPair;

public class CryptoTest {

	@Test
	public void testSignData() throws Exception {
		// generate random data that is signed and verified
		Random r = new Random(System.currentTimeMillis());
		byte[] unsignedBytes = new byte[10];
		r.nextBytes(unsignedBytes);

		// generate key pair
		EcdsaP256KeyPair keyPair = CryptoLib.generateKeyPair();

		// sign data
		byte[] signatureBytes = CryptoLib.signWithEcdsaNistp256WithSha256(unsignedBytes,
				keyPair.getPrivateKey());

		// verify data
		boolean result = CryptoLib.verifyWithEcdsaNistp256WithSha256(unsignedBytes, signatureBytes,
				keyPair.getPublicKeyX(), keyPair.getPublicKeyY());
		
		assertTrue(result);
	}
}
