package de.fraunhofer.sit.c2x;

import de.fraunhofer.sit.c2x.pki.ca.certificates.datacontainers.GeographicRegionDataContainer;

public class RegionRestriction {
	private final RegionRestrictionType type;
	private final Double circularRegionRestrictionCenterLatitude, circularRegionRestrictionCenterLongitude;
	private final Integer circularRegionRestrictionRadius;
	private final Double[] rectangularRegionRestrictionNorthWestPointsLatitude,
			rectangularRegionRestrictionNorthWestPointsLongitude,
			rectangularRegionRestrictionSouthEastPointsLatitude,
			rectangularRegionRestrictionSouthEastPointsLongitude;
	private final Double[] polygonalRegionRestrictionPointsLatitude,
			polygonalRegionRestrictionPointsLongitude;
	private final String identifiedRegionRestrictionDictionary;
	private final Long identifiedRegionRestrictionIdentifer, identifiedRegionRestrictionLocalRegion;

	public RegionRestriction(Double circularRegionRestrictionCenterLatitude,
			Double circularRegionRestrictionCenterLongitude, Integer circularRegionRestrictionRadius) {
		super();

		this.type = RegionRestrictionType.CIRCLE;

		this.circularRegionRestrictionCenterLatitude = circularRegionRestrictionCenterLatitude;
		this.circularRegionRestrictionCenterLongitude = circularRegionRestrictionCenterLongitude;
		this.circularRegionRestrictionRadius = circularRegionRestrictionRadius;

		this.rectangularRegionRestrictionNorthWestPointsLatitude = null;
		this.rectangularRegionRestrictionNorthWestPointsLongitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLatitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLongitude = null;

		this.polygonalRegionRestrictionPointsLatitude = null;
		this.polygonalRegionRestrictionPointsLongitude = null;

		this.identifiedRegionRestrictionDictionary = null;
		this.identifiedRegionRestrictionIdentifer = null;
		this.identifiedRegionRestrictionLocalRegion = null;
	}

	public RegionRestriction(Double[] rectangularRegionRestrictionNorthWestPointsLatitude,
			Double[] rectangularRegionRestrictionNorthWestPointsLongitude,
			Double[] rectangularRegionRestrictionSouthEastPointsLatitude,
			Double[] rectangularRegionRestrictionSouthEastPointsLongitude) {
		super();

		this.type = RegionRestrictionType.RECTANGLE;

		this.circularRegionRestrictionCenterLatitude = null;
		this.circularRegionRestrictionCenterLongitude = null;
		this.circularRegionRestrictionRadius = null;

		this.rectangularRegionRestrictionNorthWestPointsLatitude = rectangularRegionRestrictionNorthWestPointsLatitude;
		this.rectangularRegionRestrictionNorthWestPointsLongitude = rectangularRegionRestrictionNorthWestPointsLongitude;
		this.rectangularRegionRestrictionSouthEastPointsLatitude = rectangularRegionRestrictionSouthEastPointsLatitude;
		this.rectangularRegionRestrictionSouthEastPointsLongitude = rectangularRegionRestrictionSouthEastPointsLongitude;

		this.polygonalRegionRestrictionPointsLatitude = null;
		this.polygonalRegionRestrictionPointsLongitude = null;

		this.identifiedRegionRestrictionDictionary = null;
		this.identifiedRegionRestrictionIdentifer = null;
		this.identifiedRegionRestrictionLocalRegion = null;
	}

	public RegionRestriction(Double[] polygonalRegionRestrictionPointsLatitude,
			Double[] polygonalRegionRestrictionPointsLongitude) {
		super();

		this.type = RegionRestrictionType.POLYGON;

		this.circularRegionRestrictionCenterLatitude = null;
		this.circularRegionRestrictionCenterLongitude = null;
		this.circularRegionRestrictionRadius = null;

		this.rectangularRegionRestrictionNorthWestPointsLatitude = null;
		this.rectangularRegionRestrictionNorthWestPointsLongitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLatitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLongitude = null;

		this.polygonalRegionRestrictionPointsLatitude = polygonalRegionRestrictionPointsLatitude;
		this.polygonalRegionRestrictionPointsLongitude = polygonalRegionRestrictionPointsLongitude;

		this.identifiedRegionRestrictionDictionary = null;
		this.identifiedRegionRestrictionIdentifer = null;
		this.identifiedRegionRestrictionLocalRegion = null;
	}

	public RegionRestriction(String identifiedRegionRestrictionDictionary,
			Long identifiedRegionRestrictionIdentifer, Long identifiedRegionRestrictionLocalRegion) {
		super();

		this.type = RegionRestrictionType.ID;

		this.circularRegionRestrictionCenterLatitude = null;
		this.circularRegionRestrictionCenterLongitude = null;
		this.circularRegionRestrictionRadius = null;

		this.rectangularRegionRestrictionNorthWestPointsLatitude = null;
		this.rectangularRegionRestrictionNorthWestPointsLongitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLatitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLongitude = null;

		this.polygonalRegionRestrictionPointsLatitude = null;
		this.polygonalRegionRestrictionPointsLongitude = null;

		this.identifiedRegionRestrictionDictionary = identifiedRegionRestrictionDictionary;
		this.identifiedRegionRestrictionIdentifer = identifiedRegionRestrictionIdentifer;
		this.identifiedRegionRestrictionLocalRegion = identifiedRegionRestrictionLocalRegion;
	}

	public RegionRestriction() {
		super();
		this.type = RegionRestrictionType.NONE;

		this.circularRegionRestrictionCenterLatitude = null;
		this.circularRegionRestrictionCenterLongitude = null;
		this.circularRegionRestrictionRadius = null;

		this.rectangularRegionRestrictionNorthWestPointsLatitude = null;
		this.rectangularRegionRestrictionNorthWestPointsLongitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLatitude = null;
		this.rectangularRegionRestrictionSouthEastPointsLongitude = null;

		this.polygonalRegionRestrictionPointsLatitude = null;
		this.polygonalRegionRestrictionPointsLongitude = null;

		this.identifiedRegionRestrictionDictionary = null;
		this.identifiedRegionRestrictionIdentifer = null;
		this.identifiedRegionRestrictionLocalRegion = null;
	}

	public RegionRestrictionType getType() {
		return type;
	}

	public Double getCircularRegionRestrictionCenterLatitude() {
		return circularRegionRestrictionCenterLatitude;
	}

	public Double getCircularRegionRestrictionCenterLongitude() {
		return circularRegionRestrictionCenterLongitude;
	}

	public Integer getCircularRegionRestrictionRadius() {
		return circularRegionRestrictionRadius;
	}

	public Double[] getRectangularRegionRestrictionNorthWestPointsLatitude() {
		return rectangularRegionRestrictionNorthWestPointsLatitude;
	}

	public Double[] getRectangularRegionRestrictionNorthWestPointsLongitude() {
		return rectangularRegionRestrictionNorthWestPointsLongitude;
	}

	public Double[] getRectangularRegionRestrictionSouthEastPointsLatitude() {
		return rectangularRegionRestrictionSouthEastPointsLatitude;
	}

	public Double[] getRectangularRegionRestrictionSouthEastPointsLongitude() {
		return rectangularRegionRestrictionSouthEastPointsLongitude;
	}

	public Double[] getPolygonalRegionRestrictionPointsLatitude() {
		return polygonalRegionRestrictionPointsLatitude;
	}

	public Double[] getPolygonalRegionRestrictionPointsLongitude() {
		return polygonalRegionRestrictionPointsLongitude;
	}

	public String getIdentifiedRegionRestrictionDictionary() {
		return identifiedRegionRestrictionDictionary;
	}

	public Long getIdentifiedRegionRestrictionIdentifer() {
		return identifiedRegionRestrictionIdentifer;
	}

	public Long getIdentifiedRegionRestrictionLocalRegion() {
		return identifiedRegionRestrictionLocalRegion;
	}

	public GeographicRegionDataContainer getGeographicRegionDataContainer() {
		switch (type) {
		case CIRCLE:
			return new GeographicRegionDataContainer(circularRegionRestrictionCenterLatitude,
					circularRegionRestrictionCenterLongitude, circularRegionRestrictionRadius);
		case RECTANGLE:
			return new GeographicRegionDataContainer(rectangularRegionRestrictionNorthWestPointsLatitude,
					rectangularRegionRestrictionNorthWestPointsLongitude,
					rectangularRegionRestrictionSouthEastPointsLatitude,
					rectangularRegionRestrictionSouthEastPointsLongitude);
		case POLYGON:
			return new GeographicRegionDataContainer(polygonalRegionRestrictionPointsLatitude,
					polygonalRegionRestrictionPointsLongitude);
		case ID:
			return new GeographicRegionDataContainer(identifiedRegionRestrictionDictionary,
					identifiedRegionRestrictionIdentifer, identifiedRegionRestrictionLocalRegion);
		default:
			return null;
		}
	}
}
