package de.fraunhofer.sit.c2x;

import java.math.BigInteger;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;

import de.fraunhofer.sit.c2x.pki.ca.crypto.KeyGenerator;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EccPoint;

public class EcdsaP256KeyPair {
	private BigInteger privateKey = null;
	private byte[] publicKeyX = null;
	private byte[] publicKeyY = null;
	
	public EcdsaP256KeyPair() {
		AsymmetricCipherKeyPair keyPair = KeyGenerator.getInstance().generateECKeyPair("P-256");
		EccPoint publicKey = new EccPoint(keyPair.getPublic());
		ECPrivateKeyParameters ecPrivateKeyParameters = (ECPrivateKeyParameters)keyPair.getPrivate();
		privateKey = ecPrivateKeyParameters.getD();
		publicKeyX = publicKey.getX().get();
		publicKeyY = publicKey.getY().get();
	}

	public BigInteger getPrivateKey() {
		return privateKey;
	}

	public byte[] getPublicKeyX() {
		return publicKeyX;
	}

	public byte[] getPublicKeyY() {
		return publicKeyY;
	}
}
