package de.fraunhofer.sit.c2x;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CertChain {
	// HEX encoded ETSI TS 103 097 certificate
	private String rootCert;
	// HashMap<HEX encoded ETSI TS 103 097 certificates of Authorization
	// Authority,HEX encoded ETSI TS 103 097
	// certificate>
	private Map<String, List<String>> AuthorizationTicketCerts;

	public CertChain() {
		AuthorizationTicketCerts = new HashMap<>();
	}

	public String getRootCert() {
		return rootCert;
	}

	public void setRootCert(String rootCert) {
		this.rootCert = rootCert;
	}

	public List<String> getAuthorizationTicketCerts(String AuthorizationAuthorityCert) {
		return AuthorizationTicketCerts.get(AuthorizationAuthorityCert);
	}
	
	public List<String> getAuthorizationAuthorityCerts() {
		List<String> certs = new ArrayList<>();
		for(String cert : AuthorizationTicketCerts.keySet()){
			certs.add(cert);
		}
		return certs;
	}
	
	public void putAuthorizationTicketCerts(String AuthorizationAuthorityCert, List<String> authorizationTicketCerts) {
		AuthorizationTicketCerts.put(AuthorizationAuthorityCert, authorizationTicketCerts);
	}
}
