/*************************************************************/
/* Copyright (C) 2016 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED.
 * THIS COPYRIGHT STATEMENT MAY NOT BE REMOVED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: iso_ts_24534-3 */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.Libitsivim_asn1 */
/* Created: Tue Jul 26 14:38:15 2016 */
/* ASN.1 Compiler for Java version: 6.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1 -nolistingfile
 * -nomodlistingfile -constraints -nouserconstraints -valuerefs -debug
 * -nopedantic -noinformatorymessages -uper -root -keepnames -norelaySafe
 * -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2016.07.26.14.37.28.183/oss7811412611381924702gen/LibItsIvim_asn1.gen
 * asn/ISO_TS_14906_Generic.asn asn/ITS-Container.asn asn/ISO_TS_17419.asn
 * asn/ISO_TS_14906_Application.asn asn/ISO_TS_14816.asn asn/ISO_TS_19321.asn
 * asn/ISO_TS_24534-3.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type VehicleCharacteristicsRanges from ASN1 Module IVI_.
 * @see Sequence
 */

public class VehicleCharacteristicsRanges extends Sequence {
    
    /**
     * The default constructor.
     */
    public VehicleCharacteristicsRanges()
    {
    }
    
    /**
     * Construct with AbstractData components.
     */
    public VehicleCharacteristicsRanges(ComparisonOperator comparisonOperator, 
		    Limits limits)
    {
	setComparisonOperator(comparisonOperator);
	setLimits(limits);
    }
    
    public void initComponents()
    {
	mComponents[0] = new ComparisonOperator();
	mComponents[1] = new Limits();
    }
    
    // Instance initializer
    {
	mComponents = new AbstractData[2];
    }
    
    // Method to create a specific component instance
    public AbstractData createInstance(int index)
    {
	switch (index) {
	    case 0:
		return new ComparisonOperator();
	    case 1:
		return new Limits();
	    default:
		throw new InternalError("AbstractCollection.createInstance()");
	}
	
    }
    
    
    // Methods for field "comparisonOperator"
    public ComparisonOperator getComparisonOperator()
    {
	return (ComparisonOperator)mComponents[0];
    }
    
    public void setComparisonOperator(ComparisonOperator comparisonOperator)
    {
	mComponents[0] = comparisonOperator;
    }
    
    
    // Methods for field "limits"
    public Limits getLimits()
    {
	return (Limits)mComponents[1];
    }
    
    public void setLimits(Limits limits)
    {
	mComponents[1] = limits;
    }
    
    
    
    /**
     * Define the ASN1 Type Limits from ASN1 Module IVI_.
     * @see Choice
     */
    public static class Limits extends Choice {
	
	/**
	 * The default constructor.
	 */
	public Limits()
	{
	}
	
	public static final  int  numberOfAxles_chosen = 1;
	public static final  int  vehicleDimensions_chosen = 2;
	public static final  int  vehicleWeightLimits_chosen = 3;
	public static final  int  axleWeightLimits_chosen = 4;
	public static final  int  passengerCapacity_chosen = 5;
	public static final  int  exhaustEmissionValues_chosen = 6;
	public static final  int  dieselEmissionValues_chosen = 7;
	public static final  int  soundLevel_chosen = 8;
	
	// Methods for field "numberOfAxles"
	public static Limits createLimitsWithNumberOfAxles(long numberOfAxles)
	{
	    return createLimitsWithNumberOfAxles(new INTEGER(numberOfAxles));
	}
	
	public static Limits createLimitsWithNumberOfAxles(INTEGER numberOfAxles)
	{
	    Limits __object = new Limits();

	    __object.setNumberOfAxles(numberOfAxles);
	    return __object;
	}
	
	public boolean hasNumberOfAxles()
	{
	    return getChosenFlag() == numberOfAxles_chosen;
	}
	
	public INTEGER getNumberOfAxles()
	{
	    if (hasNumberOfAxles())
		return (INTEGER)mChosenValue;
	    else
		return null;
	}
	
	public void setNumberOfAxles(long numberOfAxles)
	{
	    setNumberOfAxles(new INTEGER(numberOfAxles));
	}
	
	public void setNumberOfAxles(INTEGER numberOfAxles)
	{
	    setChosenValue(numberOfAxles);
	    setChosenFlag(numberOfAxles_chosen);
	}
	
	
	// Methods for field "vehicleDimensions"
	public static Limits createLimitsWithVehicleDimensions(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleDimensions vehicleDimensions)
	{
	    Limits __object = new Limits();

	    __object.setVehicleDimensions(vehicleDimensions);
	    return __object;
	}
	
	public boolean hasVehicleDimensions()
	{
	    return getChosenFlag() == vehicleDimensions_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleDimensions getVehicleDimensions()
	{
	    if (hasVehicleDimensions())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleDimensions)mChosenValue;
	    else
		return null;
	}
	
	public void setVehicleDimensions(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleDimensions vehicleDimensions)
	{
	    setChosenValue(vehicleDimensions);
	    setChosenFlag(vehicleDimensions_chosen);
	}
	
	
	// Methods for field "vehicleWeightLimits"
	public static Limits createLimitsWithVehicleWeightLimits(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleWeightLimits vehicleWeightLimits)
	{
	    Limits __object = new Limits();

	    __object.setVehicleWeightLimits(vehicleWeightLimits);
	    return __object;
	}
	
	public boolean hasVehicleWeightLimits()
	{
	    return getChosenFlag() == vehicleWeightLimits_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleWeightLimits getVehicleWeightLimits()
	{
	    if (hasVehicleWeightLimits())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleWeightLimits)mChosenValue;
	    else
		return null;
	}
	
	public void setVehicleWeightLimits(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleWeightLimits vehicleWeightLimits)
	{
	    setChosenValue(vehicleWeightLimits);
	    setChosenFlag(vehicleWeightLimits_chosen);
	}
	
	
	// Methods for field "axleWeightLimits"
	public static Limits createLimitsWithAxleWeightLimits(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.AxleWeightLimits axleWeightLimits)
	{
	    Limits __object = new Limits();

	    __object.setAxleWeightLimits(axleWeightLimits);
	    return __object;
	}
	
	public boolean hasAxleWeightLimits()
	{
	    return getChosenFlag() == axleWeightLimits_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.AxleWeightLimits getAxleWeightLimits()
	{
	    if (hasAxleWeightLimits())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.AxleWeightLimits)mChosenValue;
	    else
		return null;
	}
	
	public void setAxleWeightLimits(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.AxleWeightLimits axleWeightLimits)
	{
	    setChosenValue(axleWeightLimits);
	    setChosenFlag(axleWeightLimits_chosen);
	}
	
	
	// Methods for field "passengerCapacity"
	public static Limits createLimitsWithPassengerCapacity(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.PassengerCapacity passengerCapacity)
	{
	    Limits __object = new Limits();

	    __object.setPassengerCapacity(passengerCapacity);
	    return __object;
	}
	
	public boolean hasPassengerCapacity()
	{
	    return getChosenFlag() == passengerCapacity_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.PassengerCapacity getPassengerCapacity()
	{
	    if (hasPassengerCapacity())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.PassengerCapacity)mChosenValue;
	    else
		return null;
	}
	
	public void setPassengerCapacity(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.PassengerCapacity passengerCapacity)
	{
	    setChosenValue(passengerCapacity);
	    setChosenFlag(passengerCapacity_chosen);
	}
	
	
	// Methods for field "exhaustEmissionValues"
	public static Limits createLimitsWithExhaustEmissionValues(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.ExhaustEmissionValues exhaustEmissionValues)
	{
	    Limits __object = new Limits();

	    __object.setExhaustEmissionValues(exhaustEmissionValues);
	    return __object;
	}
	
	public boolean hasExhaustEmissionValues()
	{
	    return getChosenFlag() == exhaustEmissionValues_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.ExhaustEmissionValues getExhaustEmissionValues()
	{
	    if (hasExhaustEmissionValues())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.ExhaustEmissionValues)mChosenValue;
	    else
		return null;
	}
	
	public void setExhaustEmissionValues(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.ExhaustEmissionValues exhaustEmissionValues)
	{
	    setChosenValue(exhaustEmissionValues);
	    setChosenFlag(exhaustEmissionValues_chosen);
	}
	
	
	// Methods for field "dieselEmissionValues"
	public static Limits createLimitsWithDieselEmissionValues(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.DieselEmissionValues dieselEmissionValues)
	{
	    Limits __object = new Limits();

	    __object.setDieselEmissionValues(dieselEmissionValues);
	    return __object;
	}
	
	public boolean hasDieselEmissionValues()
	{
	    return getChosenFlag() == dieselEmissionValues_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.DieselEmissionValues getDieselEmissionValues()
	{
	    if (hasDieselEmissionValues())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.DieselEmissionValues)mChosenValue;
	    else
		return null;
	}
	
	public void setDieselEmissionValues(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.DieselEmissionValues dieselEmissionValues)
	{
	    setChosenValue(dieselEmissionValues);
	    setChosenFlag(dieselEmissionValues_chosen);
	}
	
	
	// Methods for field "soundLevel"
	public static Limits createLimitsWithSoundLevel(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.SoundLevel soundLevel)
	{
	    Limits __object = new Limits();

	    __object.setSoundLevel(soundLevel);
	    return __object;
	}
	
	public boolean hasSoundLevel()
	{
	    return getChosenFlag() == soundLevel_chosen;
	}
	
	public org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.SoundLevel getSoundLevel()
	{
	    if (hasSoundLevel())
		return (org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.SoundLevel)mChosenValue;
	    else
		return null;
	}
	
	public void setSoundLevel(org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.SoundLevel soundLevel)
	{
	    setChosenValue(soundLevel);
	    setChosenFlag(soundLevel_chosen);
	}
	
	
	// Method to create a specific choice instance
	public AbstractData createInstance(int chosen)
	{
	    switch (chosen) {
		case numberOfAxles_chosen:
		    return new INTEGER();
		case vehicleDimensions_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleDimensions();
		case vehicleWeightLimits_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.VehicleWeightLimits();
		case axleWeightLimits_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.AxleWeightLimits();
		case passengerCapacity_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.PassengerCapacity();
		case exhaustEmissionValues_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.ExhaustEmissionValues();
		case dieselEmissionValues_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.DieselEmissionValues();
		case soundLevel_chosen:
		    return new org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication.SoundLevel();
		default:
		    throw new InternalError("Choice.createInstance()");
	    }
	    
	}
	
	/**
	 * Initialize the type descriptor.
	 */
	private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	    new Tags (
		new short[] {
		    (short)0x8001
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		"VehicleCharacteristicsRanges$Limits"
	    ),
	    new QName (
		"builtin",
		"CHOICE"
	    ),
	    274462,
	    null,
	    new Fields (
		new FieldInfo[] {
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8000
				    }
				),
				new QName (
				    "com.oss.asn1",
				    "INTEGER"
				),
				new QName (
				    "builtin",
				    "INTEGER"
				),
				274458,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new com.oss.asn1.INTEGER(0), 
					new com.oss.asn1.INTEGER(7),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(0),
				    new java.lang.Long(7)
				),
				null
			    )
			),
			"numberOfAxles",
			0,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8001
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "VehicleDimensions"
				),
				new QName (
				    "EfcDsrcApplication",
				    "VehicleDimensions"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"VehicleDimensions"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"VehicleDimensions"
				    )
				),
				0
			    )
			),
			"vehicleDimensions",
			1,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8002
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "VehicleWeightLimits"
				),
				new QName (
				    "EfcDsrcApplication",
				    "VehicleWeightLimits"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"VehicleWeightLimits"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"VehicleWeightLimits"
				    )
				),
				0
			    )
			),
			"vehicleWeightLimits",
			2,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8003
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "AxleWeightLimits"
				),
				new QName (
				    "EfcDsrcApplication",
				    "AxleWeightLimits"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"AxleWeightLimits"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"AxleWeightLimits"
				    )
				),
				0
			    )
			),
			"axleWeightLimits",
			3,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8004
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "PassengerCapacity"
				),
				new QName (
				    "EfcDsrcApplication",
				    "PassengerCapacity"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"PassengerCapacity"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"PassengerCapacity"
				    )
				),
				0
			    )
			),
			"passengerCapacity",
			4,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8005
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "ExhaustEmissionValues"
				),
				new QName (
				    "EfcDsrcApplication",
				    "ExhaustEmissionValues"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"ExhaustEmissionValues"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"ExhaustEmissionValues"
				    )
				),
				0
			    )
			),
			"exhaustEmissionValues",
			5,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8006
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "DieselEmissionValues"
				),
				new QName (
				    "EfcDsrcApplication",
				    "DieselEmissionValues"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"DieselEmissionValues"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"DieselEmissionValues"
				    )
				),
				0
			    )
			),
			"dieselEmissionValues",
			6,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8007
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
				    "SoundLevel"
				),
				new QName (
				    "EfcDsrcApplication",
				    "SoundLevel"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"SoundLevel"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.efcdsrcapplication",
					"SoundLevel"
				    )
				),
				0
			    )
			),
			"soundLevel",
			7,
			2
		    )
		}
	    ),
	    0,
	    new TagDecoder (
		new TagDecoderElement[] {
		    new TagDecoderElement((short)0x8000, 0),
		    new TagDecoderElement((short)0x8001, 1),
		    new TagDecoderElement((short)0x8002, 2),
		    new TagDecoderElement((short)0x8003, 3),
		    new TagDecoderElement((short)0x8004, 4),
		    new TagDecoderElement((short)0x8005, 5),
		    new TagDecoderElement((short)0x8006, 6),
		    new TagDecoderElement((short)0x8007, 7)
		}
	    )
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' Limits object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' Limits object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Check the current selection on unknown extension
	 */
	public final boolean hasUnknownExtension()
	{
	    return getChosenFlag() > 8;
	}
	
    } // End class definition for Limits

    /**
     * Initialize the type descriptor.
     */
    private static final SequenceInfo c_typeinfo = new SequenceInfo (
	new Tags (
	    new short[] {
		0x0010
	    }
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
	    "VehicleCharacteristicsRanges"
	),
	new QName (
	    "IVI",
	    "VehicleCharacteristicsRanges"
	),
	274458,
	null,
	new Fields (
	    new SequenceFieldInfo[] {
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				"ComparisonOperator"
			    ),
			    new QName (
				"IVI",
				"ComparisonOperator"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new ComparisonOperator(0), 
				    new ComparisonOperator(3),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(3)
			    ),
			    new MemberList (
				new MemberListElement[] {
				    new MemberListElement (
					"greaterThan",
					0
				    ),
				    new MemberListElement (
					"greaterThanOrEqualTo",
					1
				    ),
				    new MemberListElement (
					"lessThan",
					2
				    ),
				    new MemberListElement (
					"lessThanOrEqualTo",
					3
				    )
				}
			    )
			)
		    ),
		    "comparisonOperator",
		    0,
		    2,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			    "VehicleCharacteristicsRanges$Limits"
			)
		    ),
		    "limits",
		    1,
		    2,
		    null
		)
	    }
	),
	0,
	new TagDecoders (
	    new TagDecoder[] {
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8001, 1)
		    }
		)
	    }
	),
	0
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' VehicleCharacteristicsRanges object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' VehicleCharacteristicsRanges object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for VehicleCharacteristicsRanges
