/*************************************************************/
/* Copyright (C) 2016 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED.
 * THIS COPYRIGHT STATEMENT MAY NOT BE REMOVED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: iso_ts_24534-3 */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.Libitsivim_asn1 */
/* Created: Tue Jul 26 14:38:15 2016 */
/* ASN.1 Compiler for Java version: 6.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1 -nolistingfile
 * -nomodlistingfile -constraints -nouserconstraints -valuerefs -debug
 * -nopedantic -noinformatorymessages -uper -root -keepnames -norelaySafe
 * -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2016.07.26.14.37.28.183/oss7811412611381924702gen/LibItsIvim_asn1.gen
 * asn/ISO_TS_14906_Generic.asn asn/ITS-Container.asn asn/ISO_TS_17419.asn
 * asn/ISO_TS_14906_Application.asn asn/ISO_TS_14816.asn asn/ISO_TS_19321.asn
 * asn/ISO_TS_24534-3.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type RSCode from ASN1 Module IVI_.
 * @see Sequence
 */

public class RSCode extends Sequence {
    
    /**
     * The default constructor.
     */
    public RSCode()
    {
    }
    
    /**
     * Construct with AbstractData components.
     */
    public RSCode(INTEGER layoutComponentId, Code code)
    {
	setLayoutComponentId(layoutComponentId);
	setCode(code);
    }
    
    /**
     * Construct with components.
     */
    public RSCode(long layoutComponentId, Code code)
    {
	this(new INTEGER(layoutComponentId), code);
    }
    
    /**
     * Construct with required components.
     */
    public RSCode(Code code)
    {
	setCode(code);
    }
    
    public void initComponents()
    {
	mComponents[0] = new INTEGER();
	mComponents[1] = new Code();
    }
    
    // Instance initializer
    {
	mComponents = new AbstractData[2];
    }
    
    // Method to create a specific component instance
    public AbstractData createInstance(int index)
    {
	switch (index) {
	    case 0:
		return new INTEGER();
	    case 1:
		return new Code();
	    default:
		throw new InternalError("AbstractCollection.createInstance()");
	}
	
    }
    
    
    // Methods for field "layoutComponentId"
    public long getLayoutComponentId()
    {
	return ((INTEGER)mComponents[0]).longValue();
    }
    
    public void setLayoutComponentId(long layoutComponentId)
    {
	setLayoutComponentId(new INTEGER(layoutComponentId));
    }
    
    public void setLayoutComponentId(INTEGER layoutComponentId)
    {
	mComponents[0] = layoutComponentId;
    }
    
    public boolean hasLayoutComponentId()
    {
	return componentIsPresent(0);
    }
    
    public void deleteLayoutComponentId()
    {
	setComponentAbsent(0);
    }
    
    
    // Methods for field "code"
    public Code getCode()
    {
	return (Code)mComponents[1];
    }
    
    public void setCode(Code code)
    {
	mComponents[1] = code;
    }
    
    
    
    /**
     * Define the ASN1 Type Code from ASN1 Module IVI_.
     * @see Choice
     */
    public static class Code extends Choice {
	
	/**
	 * The default constructor.
	 */
	public Code()
	{
	}
	
	public static final  int  viennaConvention_chosen = 1;
	public static final  int  iso14823_chosen = 2;
	public static final  int  itisCodes_chosen = 3;
	public static final  int  anyCatalogue_chosen = 4;
	
	// Methods for field "viennaConvention"
	public static Code createCodeWithViennaConvention(VcCode viennaConvention)
	{
	    Code __object = new Code();

	    __object.setViennaConvention(viennaConvention);
	    return __object;
	}
	
	public boolean hasViennaConvention()
	{
	    return getChosenFlag() == viennaConvention_chosen;
	}
	
	public VcCode getViennaConvention()
	{
	    if (hasViennaConvention())
		return (VcCode)mChosenValue;
	    else
		return null;
	}
	
	public void setViennaConvention(VcCode viennaConvention)
	{
	    setChosenValue(viennaConvention);
	    setChosenFlag(viennaConvention_chosen);
	}
	
	
	// Methods for field "iso14823"
	public static Code createCodeWithIso14823(ISO14823Code iso14823)
	{
	    Code __object = new Code();

	    __object.setIso14823(iso14823);
	    return __object;
	}
	
	public boolean hasIso14823()
	{
	    return getChosenFlag() == iso14823_chosen;
	}
	
	public ISO14823Code getIso14823()
	{
	    if (hasIso14823())
		return (ISO14823Code)mChosenValue;
	    else
		return null;
	}
	
	public void setIso14823(ISO14823Code iso14823)
	{
	    setChosenValue(iso14823);
	    setChosenFlag(iso14823_chosen);
	}
	
	
	// Methods for field "itisCodes"
	public static Code createCodeWithItisCodes(long itisCodes)
	{
	    return createCodeWithItisCodes(new INTEGER(itisCodes));
	}
	
	public static Code createCodeWithItisCodes(INTEGER itisCodes)
	{
	    Code __object = new Code();

	    __object.setItisCodes(itisCodes);
	    return __object;
	}
	
	public boolean hasItisCodes()
	{
	    return getChosenFlag() == itisCodes_chosen;
	}
	
	public INTEGER getItisCodes()
	{
	    if (hasItisCodes())
		return (INTEGER)mChosenValue;
	    else
		return null;
	}
	
	public void setItisCodes(long itisCodes)
	{
	    setItisCodes(new INTEGER(itisCodes));
	}
	
	public void setItisCodes(INTEGER itisCodes)
	{
	    setChosenValue(itisCodes);
	    setChosenFlag(itisCodes_chosen);
	}
	
	
	// Methods for field "anyCatalogue"
	public static Code createCodeWithAnyCatalogue(AnyCatalogue anyCatalogue)
	{
	    Code __object = new Code();

	    __object.setAnyCatalogue(anyCatalogue);
	    return __object;
	}
	
	public boolean hasAnyCatalogue()
	{
	    return getChosenFlag() == anyCatalogue_chosen;
	}
	
	public AnyCatalogue getAnyCatalogue()
	{
	    if (hasAnyCatalogue())
		return (AnyCatalogue)mChosenValue;
	    else
		return null;
	}
	
	public void setAnyCatalogue(AnyCatalogue anyCatalogue)
	{
	    setChosenValue(anyCatalogue);
	    setChosenFlag(anyCatalogue_chosen);
	}
	
	
	// Method to create a specific choice instance
	public AbstractData createInstance(int chosen)
	{
	    switch (chosen) {
		case viennaConvention_chosen:
		    return new VcCode();
		case iso14823_chosen:
		    return new ISO14823Code();
		case itisCodes_chosen:
		    return new INTEGER();
		case anyCatalogue_chosen:
		    return new AnyCatalogue();
		default:
		    throw new InternalError("Choice.createInstance()");
	    }
	    
	}
	
	/**
	 * Initialize the type descriptor.
	 */
	private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	    new Tags (
		new short[] {
		    (short)0x8001
		}
	    ),
	    new QName (
		"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
		"RSCode$Code"
	    ),
	    new QName (
		"builtin",
		"CHOICE"
	    ),
	    274462,
	    null,
	    new Fields (
		new FieldInfo[] {
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8000
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "VcCode"
				),
				new QName (
				    "IVI",
				    "VcCode"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"VcCode"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"VcCode"
				    )
				),
				0
			    )
			),
			"viennaConvention",
			0,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8001
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "ISO14823Code"
				),
				new QName (
				    "IVI",
				    "ISO14823Code"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"ISO14823Code"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"ISO14823Code"
				    )
				),
				0
			    )
			),
			"iso14823",
			1,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new IntegerInfo (
				new Tags (
				    new short[] {
					(short)0x8002
				    }
				),
				new QName (
				    "com.oss.asn1",
				    "INTEGER"
				),
				new QName (
				    "builtin",
				    "INTEGER"
				),
				274458,
				new ValueRangeConstraint (
				    new AbstractBounds(
					new com.oss.asn1.INTEGER(0), 
					new com.oss.asn1.INTEGER(65535),
					0
				    )
				),
				new Bounds (
				    new java.lang.Long(0),
				    new java.lang.Long(65535)
				),
				null
			    )
			),
			"itisCodes",
			2,
			2
		    ),
		    new FieldInfo (
			new TypeInfoRef (
			    new SequenceInfo (
				new Tags (
				    new short[] {
					(short)0x8003
				    }
				),
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
				    "AnyCatalogue"
				),
				new QName (
				    "IVI",
				    "AnyCatalogue"
				),
				274458,
				null,
				new FieldsRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"AnyCatalogue"
				    )
				),
				0,
				new TagDecodersRef (
				    new QName (
					"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
					"AnyCatalogue"
				    )
				),
				0
			    )
			),
			"anyCatalogue",
			3,
			2
		    )
		}
	    ),
	    0,
	    new TagDecoder (
		new TagDecoderElement[] {
		    new TagDecoderElement((short)0x8000, 0),
		    new TagDecoderElement((short)0x8001, 1),
		    new TagDecoderElement((short)0x8002, 2),
		    new TagDecoderElement((short)0x8003, 3)
		}
	    )
	);
	
	/**
	 * Get the type descriptor (TypeInfo) of 'this' Code object.
	 */
	public TypeInfo getTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Get the static type descriptor (TypeInfo) of 'this' Code object.
	 */
	public static TypeInfo getStaticTypeInfo()
	{
	    return c_typeinfo;
	}
	
	/**
	 * Check the current selection on unknown extension
	 */
	public final boolean hasUnknownExtension()
	{
	    return getChosenFlag() > 4;
	}
	
    } // End class definition for Code

    /**
     * Initialize the type descriptor.
     */
    private static final SequenceInfo c_typeinfo = new SequenceInfo (
	new Tags (
	    new short[] {
		0x0010
	    }
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
	    "RSCode"
	),
	new QName (
	    "IVI",
	    "RSCode"
	),
	274458,
	null,
	new Fields (
	    new SequenceFieldInfo[] {
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"com.oss.asn1",
				"INTEGER"
			    ),
			    new QName (
				"builtin",
				"INTEGER"
			    ),
			    274462,
			    new ExtensibleConstraint (
				new ValueRangeConstraint (
				    new AbstractBounds(
					new com.oss.asn1.INTEGER(1), 
					new com.oss.asn1.INTEGER(4),
					0
				    )
				),
				null
			    ),
			    new Bounds (
				new java.lang.Long(1),
				new java.lang.Long(4)
			    ),
			    null
			)
		    ),
		    "layoutComponentId",
		    0,
		    3,
		    null
		),
		new SequenceFieldInfo (
		    new TypeInfoRef (
			new QName (
			    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.ivi_",
			    "RSCode$Code"
			)
		    ),
		    "code",
		    1,
		    2,
		    null
		)
	    }
	),
	0,
	new TagDecoders (
	    new TagDecoder[] {
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8000, 0),
			new TagDecoderElement((short)0x8001, 1)
		    }
		),
		new TagDecoder (
		    new TagDecoderElement[] {
			new TagDecoderElement((short)0x8001, 1)
		    }
		)
	    }
	),
	0
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' RSCode object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' RSCode object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for RSCode
