/*************************************************************/
/* Copyright (C) 2016 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED.
 * THIS COPYRIGHT STATEMENT MAY NOT BE REMOVED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: iso_ts_24534-3 */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.Libitsivim_asn1 */
/* Created: Tue Jul 26 14:38:15 2016 */
/* ASN.1 Compiler for Java version: 6.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1 -nolistingfile
 * -nomodlistingfile -constraints -nouserconstraints -valuerefs -debug
 * -nopedantic -noinformatorymessages -uper -root -keepnames -norelaySafe
 * -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2016.07.26.14.37.28.183/oss7811412611381924702gen/LibItsIvim_asn1.gen
 * asn/ISO_TS_14906_Generic.asn asn/ITS-Container.asn asn/ISO_TS_17419.asn
 * asn/ISO_TS_14906_Application.asn asn/ISO_TS_14816.asn asn/ISO_TS_19321.asn
 * asn/ISO_TS_24534-3.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.citsapplmgmtids;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type VarLengthNumber from ASN1 Module CITSapplMgmtIDs.
 * @see Choice
 */

public class VarLengthNumber extends Choice {
    
    /**
     * The default constructor.
     */
    public VarLengthNumber()
    {
    }
    
    public static final  int  content_chosen = 1;
    public static final  int  extension_chosen = 2;
    
    // Methods for field "content"
    public static VarLengthNumber createVarLengthNumberWithContent(long content)
    {
	return createVarLengthNumberWithContent(new INTEGER(content));
    }
    
    public static VarLengthNumber createVarLengthNumberWithContent(INTEGER content)
    {
	VarLengthNumber __object = new VarLengthNumber();

	__object.setContent(content);
	return __object;
    }
    
    public boolean hasContent()
    {
	return getChosenFlag() == content_chosen;
    }
    
    public INTEGER getContent()
    {
	if (hasContent())
	    return (INTEGER)mChosenValue;
	else
	    return null;
    }
    
    public void setContent(long content)
    {
	setContent(new INTEGER(content));
    }
    
    public void setContent(INTEGER content)
    {
	setChosenValue(content);
	setChosenFlag(content_chosen);
    }
    
    
    // Methods for field "extension"
    public static VarLengthNumber createVarLengthNumberWithExtension(Ext1 extension)
    {
	VarLengthNumber __object = new VarLengthNumber();

	__object.setExtension(extension);
	return __object;
    }
    
    public boolean hasExtension()
    {
	return getChosenFlag() == extension_chosen;
    }
    
    public Ext1 getExtension()
    {
	if (hasExtension())
	    return (Ext1)mChosenValue;
	else
	    return null;
    }
    
    public void setExtension(Ext1 extension)
    {
	setChosenValue(extension);
	setChosenFlag(extension_chosen);
    }
    
    
    // Method to create a specific choice instance
    public AbstractData createInstance(int chosen)
    {
	switch (chosen) {
	    case content_chosen:
		return new INTEGER();
	    case extension_chosen:
		return new Ext1();
	    default:
		throw new InternalError("Choice.createInstance()");
	}
	
    }
    
    /**
     * Initialize the type descriptor.
     */
    private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	new Tags (
	    null
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.citsapplmgmtids",
	    "VarLengthNumber"
	),
	new QName (
	    "CITSapplMgmtIDs",
	    "VarLengthNumber"
	),
	274458,
	null,
	new Fields (
	    new FieldInfo[] {
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"com.oss.asn1",
				"INTEGER"
			    ),
			    new QName (
				"builtin",
				"INTEGER"
			    ),
			    274458,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new com.oss.asn1.INTEGER(0), 
				    new com.oss.asn1.INTEGER(127),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(0),
				new java.lang.Long(127)
			    ),
			    null
			)
		    ),
		    "content",
		    0,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new ChoiceInfo (
			    new Tags (
				new short[] {
				    (short)0x8001
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.citsapplmgmtids",
				"Ext1"
			    ),
			    new QName (
				"CITSapplMgmtIDs",
				"Ext1"
			    ),
			    274458,
			    null,
			    new FieldsRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsIvim_asn1.citsapplmgmtids",
				    "Ext1"
				)
			    ),
			    0,
			    new TagDecoder (
				new TagDecoderElement[] {
				    new TagDecoderElement((short)0x8000, 0),
				    new TagDecoderElement((short)0x8001, 1)
				}
			    )
			)
		    ),
		    "extension",
		    1,
		    2
		)
	    }
	),
	0,
	new TagDecoder (
	    new TagDecoderElement[] {
		new TagDecoderElement((short)0x8000, 0),
		new TagDecoderElement((short)0x8001, 1)
	    }
	)
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' VarLengthNumber object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' VarLengthNumber object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
} // End class definition for VarLengthNumber
