package org.etsi.tool.testingtech;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import org.etsi.adapter.ITERequired;
import org.etsi.ttcn.tci.CharstringValue;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriAddress;
import org.etsi.ttcn.tri.TriCommunicationTE;
import org.etsi.ttcn.tri.TriMessage;
import org.etsi.ttcn.tri.TriStatus;

import com.testingtech.ttcn.logging.RTLoggingConstants;
import com.testingtech.ttcn.tri.PluginIdentifier;
import com.testingtech.ttcn.tri.TAParameterIdImpl;
import com.testingtech.ttcn.tri.TAParameterServer;
import com.testingtech.ttcn.tri.TriAddressImpl;
import com.testingtech.ttcn.tri.TriMessageImpl;
import com.testingtech.ttcn.tri.TriStatusImpl;

import de.tu_berlin.cs.uebb.muttcn.runtime.RB;

public class TeRequiredImpl implements ITERequired {

	private RB RB;
	private final PluginIdentifier pluginId;
    private Logger _logger;

	public TeRequiredImpl(RB rB, PluginIdentifier pluginId) {
		RB = rB;
		this.pluginId = pluginId;
		
		Value debugLevelValue = getTaParameter("DEBUG_ENABLED");
		String debugLevel = "OFF"; 
		if (debugLevelValue!=null) {
			debugLevel = ((CharstringValue)debugLevelValue).getString();
		}
		Level level = Level.OFF;
		if (debugLevel.equalsIgnoreCase("ALL")) {
			level = Level.ALL;
		} else if (debugLevel.equalsIgnoreCase("INFO")) {
			level = Level.INFO;
		} else if (!debugLevel.equalsIgnoreCase("OFF")) {
			RB.getTciTLProvided_Latest().tliInfo("",
					de.tu_berlin.cs.uebb.muttcn.runtime.RB.currentTimeNanos(), "",
					-1, RB.self(), RTLoggingConstants.RT_LOG_ERROR, "Unsupported logging level: " + debugLevel);
		}
		_logger = Logger.getLogger("org.etsi.its"); //$NON-NLS-1$
		_logger.addHandler(new ConsoleHandler() {
			/* (non-Javadoc)
			 * @see java.util.logging.ConsoleHandler#publish(java.util.logging.LogRecord)
			 */
			@Override
			public void publish(LogRecord logRecord) {
			  int level = RTLoggingConstants.RT_LOG_DEBUG;
			  if (logRecord.getLevel().intValue() == Level.SEVERE.intValue()) {
				  level = RTLoggingConstants.RT_LOG_ERROR;
			  }
			  RB.getTciTLProvided_Latest().tliInfo("",
					  de.tu_berlin.cs.uebb.muttcn.runtime.RB.currentTimeNanos(), "",
					  -1, RB.self(), level, logRecord.getMessage());
			}
			
		});
		_logger.setUseParentHandlers(false);
		_logger.setLevel(level);
	}

	@Override
	public TriCommunicationTE getCommunicationTE() {
		return RB.getTriCommunicationTE();
	}

	@Override
	public Value getTaParameter(String param) {
		if (RB.TestAdapter instanceof TAParameterServer) {
			TAParameterServer paramServer = (TAParameterServer)RB.TestAdapter;
			return paramServer.getTAParameter(pluginId, TAParameterIdImpl.valueOf(param));
		}
		RB.tciTMProvided.tciError("Could not retrieve TA parameter: " + param);
		return null;
	}

	@Override
	public TriAddress getTriAddress(byte[] message) {
		return new TriAddressImpl(message);
	}

	@Override
	public TriMessage getTriMessage(byte[] message) {
		return TriMessageImpl.valueOf(message); 
	}

	@Override
	public TriStatus getTriStatus(int statusCode) {
		return new TriStatusImpl(statusCode);
	}

    @Override
	public TriStatus getTriStatus(int statusCode, String message) {
		switch(statusCode) {
		case TriStatus.TRI_OK:
			RB.getTciTLProvided_Latest().tliInfo("", de.tu_berlin.cs.uebb.muttcn.runtime.RB.currentTimeNanos(), "", -1, null, RTLoggingConstants.RT_LOG_INFO, message);
			return  new TriStatusImpl();
		default:
			return  new TriStatusImpl(message);
		}
		
	}

	@Override
	public void logDebug(String debugMessage) {
		_logger.log(Level.ALL, debugMessage);
	}
	
	@Override
	public void logError(String errorMessage) {
		_logger.log(Level.SEVERE, errorMessage);
	}
	
}
