package org.etsi.its.tool.elvior;

import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;
import org.etsi.ttcn.tri.TriMessage;


/**
 * 
 * Note that "Enable Internal Codec" field shall be set to true
 *
 */
public class LibItsMapemSpatem_asn1 extends LibIts_asn1 {
    
    /**
     * Constructor
     */
    public LibItsMapemSpatem_asn1() {
        _logger.entering("LibItsMapemSpatem_asn1", "LibItsMapemSpatem_asn1");
        _encodingName = "MAPEM_SPATEM_ETSI";
    }
    
    @Override
    public TriMessage encode(final Value template) {
        _logger.entering("LibItsMapemSpatem_asn1", "encode", template.getType().getName());
        
        TriMessage result;
        String type = String.format("%s.%s", _encodingName, template.getType().getName());
        if (template.getType().getName().endsWith("MAPEM")) {
            _encodingName = "MAPEM_PDU_Descriptions";
            result = super.encode(template);
        } else {
            _encodingName = "SPATEM_PDU_Descriptions";
            result = super.encode(template);
        }
        _encodingName = "MAPEM_SPATEM_ETSI";
        
        return result;
    }
    
    @Override
    public Value decode(final TriMessage message, final Type decodingHypothesis) {
        _logger.entering("LibItsMapemSpatem_asn1", "decode", decodingHypothesis.getName());
        
        Value result;
        if (decodingHypothesis.getName().endsWith("MAPEM")) {
            Type type = getTypeForName("MAPEM_PDU_Descriptions.MAPEM");
            _encodingName = "MAPEM_PDU_Descriptions";
            result = super.decode(message, type);
        } else {
            Type type = getTypeForName("SPATEM_PDU_Descriptions.SPATEM");
            _encodingName = "SPATEM_PDU_Descriptions";
            result = super.decode(message, type);
        }
        _encodingName = "MAPEM_SPATEM_ETSI";
        
        return result;
    }
    
} // End of class LibItsMapemSpatem_asn1 
