package org.etsi.ttcn.codec.its.adapter;

import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.UnionValue;
import org.etsi.ttcn.codec.generic.Union;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.common.ByteHelper;

public class AcGnssPrimitive extends Union {

    public AcGnssPrimitive(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    protected void preDecode(CodecBuffer buf, Type decodingHypothesis) {

        // Read message id (AcGnssPrimitive)
        if(0x00 != (0x00FF & buf.readBytes(1)[0])) {
            return;
        }

        // Read primitive id
        int primitiveId = 0x00FF & buf.readBytes(1)[0];
        String primitive = "";

        switch(primitiveId) {
        case 0x70:
            primitive = "loadScenario";
            break;
        case 0x71:
            primitive = "startScenario";
            break;
        case 0x72:
            primitive = "stopScenario";
            break;
        case 0x73:
            primitive = "distanceToCover";
            break;
        case 0x74:
            primitive = "changeSpeed";
            break;
        case 0x75:
            primitive = "changeHeading";
            break;
        }

        mainCodec.setHint(decodingHypothesis.getName(), primitive);
    }

    @Override
    protected void preEncode(CodecBuffer buf, UnionValue uv) {
        String variant = uv.getPresentVariantName();
        int primitiveId = -1;

        buf.appendBytes(ByteHelper.intToByteArray(2, 1));

        // Append primitive id
        if(variant.equals("loadScenario")) {
            primitiveId = 0x70;
            mainCodec.setHint("ScenarioLen", "16");
        }
        else if(variant.equals("startScenario")) {
            primitiveId = 0x71;
        }
        else if(variant.equals("stopScenario")) {
            primitiveId = 0x72;
        }
        else if(variant.equals("distanceToCover")) {
            primitiveId = 0x73;
        }
        else if(variant.equals("changeSpeed")) {
            primitiveId = 0x74;
        }
        else if(variant.equals("changeHeading")) {
            primitiveId = 0x75;
        }
        buf.appendBytes(ByteHelper.intToByteArray(primitiveId, 1));
    }
}
