package org.etsi.ttcn.codec.its.adapter;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Boolean;
import org.etsi.ttcn.tci.Type;
import org.etsi.ttcn.tci.Value;

public class AcGnssAwaitDistanceCovered extends Boolean {

    private static final int AcGnssDistanceCovered = 0x03;

    public AcGnssAwaitDistanceCovered(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    public Value decode(CodecBuffer buf, Type decodingHypothesis) {
        
        byte[] readId = buf.readBytes(1);
        if(readId[0] != AcGnssDistanceCovered) {
            return null;
        }
        
        return super.decode(buf, decodingHypothesis);
    }
    
    @Override
    public CodecBuffer preEncode(Value value) {
        return new CodecBuffer(new byte[] {0x02});
    }

}
