/**
 *  Factory for GNSS Support implementations. 
 *  Implementations have to register to this factory.  
 * 
 */
package org.etsi.adapter;

/**
 *  Factory for Test Execution Required implementations. 
 *  Implementations have to register to this factory.  
 */
public class GnssSupportFactory {

    /**
     * Registered IGnssSupport implementation
     */
    private static IGnssSupport instance; 

    /**
     * Gets the registered IGnssSupport implementation
     * @return Instance of IGnssSupport implementation registered through setImpl() or null
     * @see    setImpl
     */
    public static IGnssSupport getInstance() {
        return instance;
    }
    
    /**
     * Private constructor (Singleton pattern) 
     */
    private GnssSupportFactory() {
        //empty
    }
    
    /**
     * Sets the implementation instance to be returned by the factory
     * @param  impl    Instance of the implementation to be registered
     */
    public static void setImpl(IGnssSupport impl) {
        instance = impl;
    }
}
