/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9FieldElement;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;

public class X9Curve
extends ASN1Encodable
implements X9ObjectIdentifiers {
    private ECCurve curve;
    private byte[] seed;
    private DERObjectIdentifier fieldIdentifier = null;

    public X9Curve(ECCurve eCCurve) {
        this.curve = eCCurve;
        this.seed = null;
        this.setFieldIdentifier();
    }

    public X9Curve(ECCurve eCCurve, byte[] byArray) {
        this.curve = eCCurve;
        this.seed = byArray;
        this.setFieldIdentifier();
    }

    public X9Curve(X9FieldID x9FieldID, ASN1Sequence aSN1Sequence) {
        this.fieldIdentifier = x9FieldID.getIdentifier();
        if (this.fieldIdentifier.equals(prime_field)) {
            BigInteger bigInteger = ((DERInteger)x9FieldID.getParameters()).getValue();
            X9FieldElement x9FieldElement = new X9FieldElement(bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement2 = new X9FieldElement(bigInteger, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.curve = new ECCurve.Fp(bigInteger, x9FieldElement.getValue().toBigInteger(), x9FieldElement2.getValue().toBigInteger());
        } else if (this.fieldIdentifier.equals(characteristic_two_field)) {
            ASN1Encodable aSN1Encodable;
            DERSequence dERSequence = (DERSequence)x9FieldID.getParameters();
            int n = ((DERInteger)dERSequence.getObjectAt(0)).getValue().intValue();
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)dERSequence.getObjectAt(1);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (dERObjectIdentifier.equals(tpBasis)) {
                n2 = ((DERInteger)dERSequence.getObjectAt(2)).getValue().intValue();
            } else {
                aSN1Encodable = (DERSequence)dERSequence.getObjectAt(2);
                n2 = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(0)).getValue().intValue();
                n3 = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(1)).getValue().intValue();
                n4 = ((DERInteger)((ASN1Sequence)aSN1Encodable).getObjectAt(2)).getValue().intValue();
            }
            aSN1Encodable = new X9FieldElement(n, n2, n3, n4, (ASN1OctetString)aSN1Sequence.getObjectAt(0));
            X9FieldElement x9FieldElement = new X9FieldElement(n, n2, n3, n4, (ASN1OctetString)aSN1Sequence.getObjectAt(1));
            this.curve = new ECCurve.F2m(n, n2, n3, n4, ((X9FieldElement)aSN1Encodable).getValue().toBigInteger(), x9FieldElement.getValue().toBigInteger());
        }
        if (aSN1Sequence.size() == 3) {
            this.seed = ((DERBitString)aSN1Sequence.getObjectAt(2)).getBytes();
        }
    }

    private void setFieldIdentifier() {
        if (this.curve instanceof ECCurve.Fp) {
            this.fieldIdentifier = prime_field;
        } else if (this.curve instanceof ECCurve.F2m) {
            this.fieldIdentifier = characteristic_two_field;
        } else {
            throw new IllegalArgumentException("This type of ECCurve is not implemented");
        }
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.fieldIdentifier.equals(prime_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).getDERObject());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).getDERObject());
        } else if (this.fieldIdentifier.equals(characteristic_two_field)) {
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getA()).getDERObject());
            aSN1EncodableVector.add(new X9FieldElement(this.curve.getB()).getDERObject());
        }
        if (this.seed != null) {
            aSN1EncodableVector.add(new DERBitString(this.seed));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

