/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.subjects.Subject;

public final class OperatorReplay {
    private OperatorReplay() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Subject<T, T> createScheduledSubject(Subject<T, T> subject, Scheduler scheduler) {
        final Observable observedOn = subject.observeOn(scheduler);
        SubjectWrapper<T> s = new SubjectWrapper<T>(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> o) {
                OperatorReplay.subscriberOf(observedOn).call(o);
            }
        }, subject);
        return s;
    }

    public static <T> Observable.OnSubscribe<T> subscriberOf(final Observable<T> target) {
        return new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> t1) {
                target.unsafeSubscribe(t1);
            }
        };
    }

    public static final class SubjectWrapper<T>
    extends Subject<T, T> {
        final Subject<T, T> subject;

        public SubjectWrapper(Observable.OnSubscribe<T> func, Subject<T, T> subject) {
            super(func);
            this.subject = subject;
        }

        @Override
        public void onNext(T args) {
            this.subject.onNext(args);
        }

        @Override
        public void onError(Throwable e) {
            this.subject.onError(e);
        }

        @Override
        public void onCompleted() {
            this.subject.onCompleted();
        }

        @Override
        public boolean hasObservers() {
            return this.subject.hasObservers();
        }
    }
}

