/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Subscriber;

public class OperatorDefaultIfEmpty<T>
implements Observable.Operator<T, T> {
    final T defaultValue;

    public OperatorDefaultIfEmpty(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){
            boolean hasValue;

            @Override
            public void onNext(T t) {
                this.hasValue = true;
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (!this.hasValue) {
                    try {
                        child.onNext(OperatorDefaultIfEmpty.this.defaultValue);
                    }
                    catch (Throwable e) {
                        child.onError(e);
                        return;
                    }
                }
                child.onCompleted();
            }
        };
    }
}

