/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.common;

import java.nio.ByteOrder;

public class ByteHelper {
    public static byte[] changeEndianness(byte[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < in.length) {
            out[in.length - i - 1] = in[i];
            ++i;
        }
        return out;
    }

    public static byte[] intToByteArray(int value, int length, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteHelper.changeEndianness(ByteHelper.intToByteArray(value, length));
        }
        return ByteHelper.intToByteArray(value, length);
    }

    public static byte[] intToByteArray(int value, int length) {
        byte[] b = new byte[length];
        int i = length - 1;
        while (i >= 0) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
            --i;
        }
        return b;
    }

    public static byte[] longToByteArray(long value, int length, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteHelper.changeEndianness(ByteHelper.longToByteArray(value, length));
        }
        return ByteHelper.longToByteArray(value, length);
    }

    public static byte[] longToByteArray(long value, int length) {
        byte[] b = new byte[length];
        int i = length - 1;
        while (i >= 0) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFFL);
            --i;
        }
        return b;
    }

    public static Boolean byteArrayToBoolean(byte[] b) {
        if (b == null || b.length != 1) {
            return null;
        }
        return new Boolean(b[0] == 1);
    }

    public static Short byteArrayToShort(byte[] b, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteHelper.byteArrayToShort(ByteHelper.changeEndianness(b));
        }
        return ByteHelper.byteArrayToShort(b);
    }

    public static Short byteArrayToShort(byte[] b) {
        if (b == null || b.length * 8 > 16) {
            return (short)Short.MAX_VALUE;
        }
        short value = 0;
        Short i = 0;
        while (i < b.length) {
            value = (short)((value << 8) + (b[i] & 0xFF));
            i = (short)(i + 1);
        }
        return new Short(value);
    }

    public static Integer byteArrayToInt(byte[] b, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteHelper.byteArrayToInt(ByteHelper.changeEndianness(b));
        }
        return ByteHelper.byteArrayToInt(b);
    }

    public static Integer byteArrayToInt(byte[] b) {
        if (b == null || b.length * 8 > 32) {
            return Integer.MAX_VALUE;
        }
        int value = 0;
        int i = 0;
        while (i < b.length) {
            value = (value << 8) + (b[i] & 0xFF);
            ++i;
        }
        return new Integer(value);
    }

    public static Long byteArrayToLong(byte[] b, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return ByteHelper.byteArrayToLong(ByteHelper.changeEndianness(b));
        }
        return ByteHelper.byteArrayToLong(b);
    }

    public static Long byteArrayToLong(byte[] b) {
        if (b == null || b.length * 8 > 64) {
            return Long.MAX_VALUE;
        }
        long value = 0L;
        int i = 0;
        while (i < b.length) {
            value = (value << 8) + (long)(b[i] & 0xFF);
            ++i;
        }
        return new Long(value);
    }

    public static byte[] hexStringToByteArray(String s) {
        String str = "";
        String[] stringArray = s.split("[^0-9A-Fa-f]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            str = String.valueOf(str) + ss;
            ++n2;
        }
        int len = str.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            if (array != null) {
                length += array.length;
            }
            ++n2;
        }
        byte[] result = new byte[length];
        int position = 0;
        byte[][] byArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            if (array != null) {
                System.arraycopy(array, 0, result, position, array.length);
                position += array.length;
            }
            ++n4;
        }
        return result;
    }

    public static byte[] extract(byte[] array, int offset, int length) {
        if (array == null || array.length == 0 || offset > array.length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(array, offset, result, 0, length);
        return result;
    }

    public static String byteArrayWithLengthToString(byte[] b) {
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return "";
        }
        int length = ByteHelper.byteArrayToInt(ByteHelper.extract(b, 0, 4));
        String result = "";
        int i = 0;
        while (i < length) {
            result = String.valueOf(result) + (char)b[4 + i];
            ++i;
        }
        return result;
    }

    public static String byteArrayToString(byte[] buffer) {
        String result = "";
        if (buffer != null) {
            int i = 0;
            while (i < buffer.length) {
                result = String.valueOf(result) + String.format("%02X", buffer[i]);
                ++i;
            }
        }
        return result;
    }

    public static synchronized void dump(String label, byte[] buffer) {
        if (buffer != null && buffer.length != 0) {
            System.out.println(label);
            StringBuilder finalHexLine = new StringBuilder();
            StringBuilder finalCharLine = new StringBuilder();
            int nCounter = 0;
            int nOffset = 0;
            System.out.println(" HEX | 00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F  : 0 1 2 3 4 5 6 7 8 9 A B C D E F ");
            System.out.println("-----|+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+-:--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
            int i = 0;
            while (i < buffer.length) {
                byte c = buffer[i];
                String fmtHex = String.format("%02x ", c);
                String fmtChar = String.format("%c ", Character.valueOf(Character.isISOControl((char)c) || c < 0 ? (char)'.' : (char)c));
                if (nOffset % 16 == 0) {
                    finalHexLine.append(String.format("%05x| ", nOffset));
                }
                finalHexLine.append(fmtHex);
                finalCharLine.append(fmtChar);
                if (nCounter == 15) {
                    System.out.println(String.format("%s : %s", finalHexLine.toString(), finalCharLine.toString()));
                    finalHexLine.delete(0, finalHexLine.length());
                    finalCharLine.delete(0, finalCharLine.length());
                    nCounter = 0;
                } else {
                    ++nCounter;
                }
                ++nOffset;
                ++i;
            }
            if (nCounter < 16) {
                i = nCounter;
                while (i < 16) {
                    finalHexLine.append("   ");
                    finalCharLine.append("  ");
                    ++i;
                }
                System.out.println(String.format("%s : %s", finalHexLine.toString(), finalCharLine.toString()));
            }
        }
    }
}

