/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.winpcap;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JStruct;
import org.jnetpcap.packet.PeeringException;

@Library(jni={"jnetpcap"})
public class WinPcapSendQueue
extends JStruct {
    public static final int DEFAULT_QUEUE_SIZE = 65536;
    public static final String STRUCT_NAME = "pcap_send_queue";
    private final JBuffer buffer;

    public static native int sizeof();

    public WinPcapSendQueue() {
        this(65536);
    }

    public WinPcapSendQueue(byte[] byArray) {
        super(STRUCT_NAME, WinPcapSendQueue.sizeof());
        this.buffer = new JBuffer(byArray.length);
        this.buffer.order(ByteOrder.nativeOrder());
        this.buffer.setByteArray(0, byArray);
        this.setMaxLen(byArray.length);
    }

    public WinPcapSendQueue(ByteBuffer byteBuffer) throws PeeringException {
        super(STRUCT_NAME, WinPcapSendQueue.sizeof());
        this.buffer = new JBuffer(JMemory.Type.POINTER);
        this.buffer.order(ByteOrder.nativeOrder());
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Only direct buffers are accepted. See ByteBuffer.allocateDirect method.");
        }
        this.buffer.peer(byteBuffer);
        this.setMaxLen(this.buffer.size());
    }

    public WinPcapSendQueue(int n) {
        super(STRUCT_NAME, WinPcapSendQueue.sizeof());
        this.buffer = new JBuffer(n);
        this.buffer.order(ByteOrder.nativeOrder());
        this.setMaxLen(n);
        this.setBuffer(this.buffer);
    }

    public JBuffer getBuffer() {
        return this.buffer;
    }

    public native int getLen();

    public native int getMaxLen();

    public native int incLen(int var1);

    public int queue(PcapHeader pcapHeader, byte[] byArray) {
        return this.queue(pcapHeader, new JBuffer(byArray));
    }

    public int queue(PcapHeader pcapHeader, ByteBuffer byteBuffer) {
        return this.queue(pcapHeader, new JBuffer(byteBuffer));
    }

    public int queue(PcapHeader pcapHeader, JBuffer jBuffer) {
        pcapHeader.transferTo(this.buffer, 0, pcapHeader.size(), this.getLen());
        this.setLen(this.getLen() + pcapHeader.size());
        jBuffer.transferTo(this.buffer, 0, jBuffer.size(), this.getLen());
        this.setLen(this.getLen() + jBuffer.size());
        return 0;
    }

    @Deprecated
    public int queue(PcapPktHdr pcapPktHdr, byte[] byArray) {
        if (byArray.length != pcapPktHdr.getCaplen()) {
            throw new IllegalArgumentException("Buffer length does not equal length in packet header");
        }
        int n = this.getLen();
        this.buffer.setInt(n, (int)pcapPktHdr.getSeconds());
        this.buffer.setInt(n + 4, pcapPktHdr.getUseconds());
        this.buffer.setInt(n + 8, pcapPktHdr.getCaplen());
        this.buffer.setInt(n + 12, pcapPktHdr.getLen());
        this.buffer.setByteArray(n + 16, byArray);
        this.incLen(16 + byArray.length);
        return 0;
    }

    @Deprecated
    public int queue(PcapPktHdr pcapPktHdr, ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        if (n != pcapPktHdr.getCaplen()) {
            throw new IllegalArgumentException("Buffer length (limit - position) does not equal length in packet header");
        }
        int n2 = this.getLen();
        this.buffer.setInt(n2, (int)pcapPktHdr.getSeconds());
        this.buffer.setInt(n2 + 4, pcapPktHdr.getUseconds());
        this.buffer.setInt(n2 + 8, pcapPktHdr.getCaplen());
        this.buffer.setInt(n2 + 12, pcapPktHdr.getLen());
        this.buffer.setByteBuffer(n2 + 16, byteBuffer);
        this.incLen(16 + n);
        return 0;
    }

    private native void setBuffer(JBuffer var1);

    public native void setLen(int var1);

    public native void setMaxLen(int var1);

    static {
        JNILibrary.register(WinPcapSendQueue.class);
    }
}

