/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util.resolver;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jnetpcap.util.JEvent;
import org.jnetpcap.util.config.JConfig;
import org.jnetpcap.util.resolver.Resolver;

public abstract class AbstractResolver
implements Resolver,
PropertyChangeListener {
    private static final int DEFAULT_BACKOFF = 10;
    private static final String DEFAULT_CACHE_SUFFIX = ".resolver";
    private static final String DEFAULT_HOME = "@{user.home}/@{${subdir}}";
    private static final int DEFAULT_MAX_ENTRIES = 1000;
    private static final boolean DEFAULT_MKDIR_HOME = false;
    private static final long DEFAULT_NEGATIVE_TIMEOUT_IN_MILLIS = 1800000L;
    protected static final long INFINITE_TIMEOUT = 157680000000L;
    private static final long DEFAULT_POSITIVE_TIMEOUT_IN_MILLIS = 86400000L;
    private static final boolean DEFAULT_SAVE_CACHE = false;
    private static final String NEWLINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PROPERTY_BACKOFF = "resolver.%sbackoff";
    private static final String PROPERTY_CACHE_SUFFIX = "resolver.suffix";
    private static final String PROPERTY_MAX_ENTRIES = "resolver.%smaxentries";
    private static final String PROPERTY_MKDIR_HOME = "resolver.home.mkdir";
    private static final String PROPERTY_NEGATIVE_TIMEOUT = "resolver.%stimeout.negative";
    private static final String PROPERTY_POSITIVE_TIMEOUT = "resolver.%stimeout.positive";
    private static final String PROPERTY_RESOLVER_HOME = "resolver.home";
    private static final String PROPERTY_RESOLVER_HOME_SEARCH_PATH = "resolver.home.search.path";
    private static final String PROPERTY_RESOLVER_FILE_SEARCH_PATH = "resolver.search.path";
    private static final String PROPERTY_SAVE_CACHE = "resolver.%ssave";
    private int backoff = 10;
    private Map<Long, String> cache;
    private int cacheCapacity = 100;
    private float cacheLoadFactor = 0.75f;
    private boolean isModified = false;
    protected final Logger logger;
    private int maxentries = 1000;
    private boolean mkdirHome = false;
    private final String name;
    private long negativeTimeout = 1800000L;
    private long positiveTimeout = 86400000L;
    private boolean saveCache = false;
    private Queue<TimeoutEntry> timeoutQueue;

    public AbstractResolver(Logger logger, Resolver.ResolverType resolverType) {
        this(logger, resolverType.name());
    }

    public AbstractResolver(Logger logger, String string) {
        this.logger = logger;
        this.name = string;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("resolver's name must be set");
        }
    }

    public void addToCache(long l, String string) {
        if (string != null && this.positiveTimeout != 0L) {
            this.addToCache(l, string, this.positiveTimeout);
        }
        if (string == null && this.negativeTimeout != 0L) {
            this.addToCache(l, string, this.negativeTimeout);
        }
    }

    public void addToCache(long l, String string, long l2) {
        long l3;
        if (this.cache.containsKey(l)) {
            this.logger.finest(String.format("[%d] replacing %X", this.cache.size(), l));
            this.cache.remove(l);
        } else if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(String.format("[%d] adding %X %s", this.cache.size(), l, String.valueOf(string)));
        }
        this.isModified = true;
        this.cache.put(l, string);
        TimeoutEntry timeoutEntry = new TimeoutEntry(l, l2);
        this.timeoutQueue.add(timeoutEntry);
        if (this.cache.size() >= this.maxentries) {
            this.timeoutCacheOldest(this.maxentries * 100 / this.backoff);
        }
        if ((l3 = timeoutEntry.timeout - System.currentTimeMillis()) != l2) {
            this.logger.finest(String.format("invalid timeout %d != %d", l3, l2));
        }
    }

    public boolean canBeResolved(byte[] byArray) {
        return this.resolve(byArray) != null;
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
            this.isModified = true;
        }
        if (this.timeoutQueue != null) {
            this.timeoutQueue.clear();
            this.isModified = true;
        }
    }

    private void createCache() {
        this.cache = Collections.synchronizedMap(new HashMap(this.cacheCapacity, this.cacheLoadFactor));
        this.timeoutQueue = new PriorityQueue<TimeoutEntry>(this.cacheCapacity, new Comparator<TimeoutEntry>(){

            @Override
            public int compare(TimeoutEntry timeoutEntry, TimeoutEntry timeoutEntry2) {
                return (int)(timeoutEntry.timeout - timeoutEntry2.timeout);
            }
        });
    }

    private String filename() {
        String string = this.name + JConfig.getProperty(PROPERTY_CACHE_SUFFIX, DEFAULT_CACHE_SUFFIX);
        return string;
    }

    protected void finalize() throws Throwable {
        this.saveCache();
        super.finalize();
    }

    public final int getCacheCapacity() {
        return this.cacheCapacity;
    }

    public final float getCacheLoadFactor() {
        return this.cacheLoadFactor;
    }

    public final long getNegativeTimeout() {
        return this.negativeTimeout;
    }

    public final long getPositiveTimeout() {
        return this.positiveTimeout;
    }

    protected boolean hasCacheFile() {
        File file;
        try {
            file = JConfig.getFile(this.name, PROPERTY_RESOLVER_FILE_SEARCH_PATH);
        }
        catch (IOException iOException) {
            return false;
        }
        return file != null && file.canRead() && file.length() > 0L;
    }

    public void initializeIfNeeded() {
        if (this.cache == null) {
            this.createCache();
            this.initProperties();
            try {
                this.loadCache();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void initProperties() {
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_POSITIVE_TIMEOUT, ""), 86400000L);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_NEGATIVE_TIMEOUT, ""), 1800000L);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_SAVE_CACHE, ""), false);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_MAX_ENTRIES, ""), 1000);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_BACKOFF, ""), 10);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_MKDIR_HOME, ""), false);
        String string = this.name + ".";
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_POSITIVE_TIMEOUT, string), null);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_NEGATIVE_TIMEOUT, string), null);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_SAVE_CACHE, string), null);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_MAX_ENTRIES, string), null);
        JConfig.addListener((PropertyChangeListener)this, String.format(PROPERTY_BACKOFF, this.name + "."), null);
    }

    public boolean isCached(byte[] byArray) {
        return this.cache.containsKey(this.toHashCode(byArray));
    }

    public int loadCache() throws IOException {
        URL uRL = JConfig.getURL(this.name, PROPERTY_RESOLVER_FILE_SEARCH_PATH);
        if (uRL == null) {
            this.logger.fine("cache file " + this.name + " not found");
            return 0;
        }
        this.logger.finer("loading cache file " + uRL.toString());
        return this.loadCache(new BufferedReader(new InputStreamReader(uRL.openStream())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadCache(BufferedReader bufferedReader) throws IOException {
        long l = System.currentTimeMillis();
        int n = 0;
        if (this.cache == null) {
            this.createCache();
        } else {
            this.cache.clear();
        }
        Map<Long, String> map = this.cache;
        synchronized (map) {
            try {
                String string;
                boolean bl = this.isModified;
                while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    String[] stringArray = string.split(":", 3);
                    if (stringArray.length != 3) {
                        this.isModified = true;
                        this.logger.fine("corrupt entry in cache file");
                        continue;
                    }
                    long l2 = Long.parseLong(stringArray[0], 16);
                    long l3 = 0L;
                    try {
                        l3 = Long.parseLong(stringArray[1], 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                        continue;
                    }
                    String string3 = string2 = stringArray[2].length() == 0 ? null : stringArray[2];
                    if (l3 <= l) {
                        this.logger.fine(String.format("on load timeout, skipping %x %d\n", l2, (l3 - l) / 1000L));
                        this.isModified = true;
                        continue;
                    }
                    this.addToCache(l2, string2, l3 - l);
                    ++n;
                }
                this.isModified = bl;
            }
            finally {
                bufferedReader.close();
            }
        }
        return n;
    }

    public int loadCache(String string) throws IOException {
        File file = new File(string);
        if (!file.canRead()) {
            return 0;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        return this.loadCache(bufferedReader);
    }

    public int loadCache(URL uRL) throws IOException {
        return this.loadCache(new BufferedReader(new InputStreamReader(uRL.openStream())));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (String.format(PROPERTY_NEGATIVE_TIMEOUT, "").equals(propertyChangeEvent.getPropertyName())) {
            this.negativeTimeout = JEvent.longValue(propertyChangeEvent);
            if (this.negativeTimeout == -1L) {
                this.negativeTimeout = 157680000000L;
            }
        } else if (String.format(PROPERTY_POSITIVE_TIMEOUT, "").equals(propertyChangeEvent.getPropertyName())) {
            this.positiveTimeout = JEvent.longValue(propertyChangeEvent);
            if (this.positiveTimeout == -1L) {
                this.positiveTimeout = 157680000000L;
            }
        } else if (String.format(PROPERTY_SAVE_CACHE, "").equals(propertyChangeEvent.getPropertyName())) {
            this.saveCache = JEvent.booleanValue(propertyChangeEvent);
        } else if (String.format(PROPERTY_MAX_ENTRIES, "").equals(propertyChangeEvent.getPropertyName())) {
            this.maxentries = JEvent.intValue(propertyChangeEvent);
            if (this.cache.size() > this.maxentries) {
                this.timeoutCacheOldest(this.maxentries * 100 / this.backoff);
            }
        } else if (String.format(PROPERTY_BACKOFF, "").equals(propertyChangeEvent.getPropertyName())) {
            this.backoff = JEvent.intValue(propertyChangeEvent);
        } else if (String.format(PROPERTY_MKDIR_HOME, "").equals(propertyChangeEvent.getPropertyName())) {
            this.mkdirHome = JEvent.booleanValue(propertyChangeEvent);
        } else if (String.format(PROPERTY_NEGATIVE_TIMEOUT, this.name + ".").equals(propertyChangeEvent.getPropertyName())) {
            this.negativeTimeout = JEvent.longValue(propertyChangeEvent);
            if (this.negativeTimeout == -1L) {
                this.negativeTimeout = 157680000000L;
            }
        } else if (String.format(PROPERTY_POSITIVE_TIMEOUT, this.name + ".").equals(propertyChangeEvent.getPropertyName())) {
            this.positiveTimeout = JEvent.longValue(propertyChangeEvent);
            if (this.positiveTimeout == -1L) {
                this.positiveTimeout = 157680000000L;
            }
        } else if (String.format(PROPERTY_SAVE_CACHE, this.name + ".").equals(propertyChangeEvent.getPropertyName())) {
            this.saveCache = JEvent.booleanValue(propertyChangeEvent);
        } else if (String.format(PROPERTY_MAX_ENTRIES, this.name + ".").equals(propertyChangeEvent.getPropertyName())) {
            this.maxentries = JEvent.intValue(propertyChangeEvent);
            if (this.cache.size() > this.maxentries) {
                this.timeoutCacheOldest(this.maxentries * 100 / this.backoff);
            }
        } else if (String.format(PROPERTY_BACKOFF, this.name + ".").equals(propertyChangeEvent.getPropertyName())) {
            this.backoff = JEvent.intValue(propertyChangeEvent);
        }
    }

    public final String resolve(byte[] byArray) {
        this.timeoutCache();
        long l = this.toHashCode(byArray);
        if (this.cache.containsKey(l)) {
            return this.cache.get(l);
        }
        String string = this.resolveToName(byArray, l);
        this.addToCache(l, string);
        return string;
    }

    protected abstract String resolveToName(byte[] var1, long var2);

    protected abstract String resolveToName(long var1, long var3);

    public int saveCache() throws IOException {
        this.timeoutCache();
        if (!this.saveCache || !this.isModified || this.timeoutQueue.isEmpty()) {
            return 0;
        }
        URL uRL = JConfig.getURL(this.name, PROPERTY_RESOLVER_FILE_SEARCH_PATH);
        if (uRL == null) {
            this.logger.fine("cache file " + this.name + " not found");
            File file = JConfig.getDir(PROPERTY_RESOLVER_HOME_SEARCH_PATH);
            if (file == null) {
                this.logger.fine("cache directory not found");
                if (this.mkdirHome) {
                    this.logger.fine("attempting to create cache directory using property resolver.home");
                    file = JConfig.createDir(PROPERTY_RESOLVER_HOME, DEFAULT_HOME);
                    if (file == null) {
                        return 0;
                    }
                } else {
                    this.logger.finer("property resolver.home.mkdir set to false, giving up");
                    return 0;
                }
            }
            uRL = new File(file, this.filename()).toURI().toURL();
        }
        this.logger.finer("saving cache " + uRL.toString());
        int n = this.saveCache(new PrintWriter(new OutputStreamWriter(new FileOutputStream(uRL.getFile()))));
        if (n == 0) {
            throw new IllegalStateException("Saved empty cache");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveCache(PrintWriter printWriter) {
        int n = 0;
        this.logger.finer(String.format("saving %d entries", this.cache.size()));
        Map<Long, String> map = this.cache;
        synchronized (map) {
            try {
                for (TimeoutEntry timeoutEntry : this.timeoutQueue) {
                    String string = this.cache.get(timeoutEntry.hash);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(String.format("saving %X %X\n", timeoutEntry.hash, timeoutEntry.timeout - System.currentTimeMillis()));
                    }
                    printWriter.format("%X:%d:%s" + NEWLINE_SEPARATOR, timeoutEntry.hash, timeoutEntry.timeout, string == null ? "" : string);
                    ++n;
                }
            }
            finally {
                printWriter.close();
            }
        }
        return n;
    }

    public int saveCache(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        if (!file.createNewFile()) {
            return 0;
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        return this.saveCache(printWriter);
    }

    public final void setCacheCapacity(int n) {
        this.cacheCapacity = n;
    }

    public final void setCacheLoadFactor(float f) {
        this.cacheLoadFactor = f;
    }

    public final void setNegativeTimeout(long l) {
        JConfig.setProperty(String.format(PROPERTY_NEGATIVE_TIMEOUT, this.name + "."), Long.toString(l));
    }

    public final void setPositiveTimeout(long l) {
        JConfig.setProperty(String.format(PROPERTY_POSITIVE_TIMEOUT, this.name + "."), Long.toString(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutCache() {
        long l = System.currentTimeMillis();
        Map<Long, String> map = this.cache;
        synchronized (map) {
            Iterator iterator = this.timeoutQueue.iterator();
            while (iterator.hasNext()) {
                TimeoutEntry timeoutEntry = (TimeoutEntry)iterator.next();
                if (timeoutEntry.timeout >= l) break;
                System.out.printf("%s: %s %s\n", "timeout()", this.logger, this.logger.getLevel());
                this.logger.finest(String.format("timedout %s\n", this.cache.get(timeoutEntry.hash)));
                this.cache.remove(timeoutEntry.hash);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutCacheOldest(int n) {
        Map<Long, String> map = this.cache;
        synchronized (map) {
            Iterator iterator = this.timeoutQueue.iterator();
            while (iterator.hasNext()) {
                TimeoutEntry timeoutEntry = (TimeoutEntry)iterator.next();
                if (n-- <= 0) break;
                this.logger.finest(String.format("removed due to backoff %s \n", this.cache.get(timeoutEntry.hash)));
                this.cache.remove(timeoutEntry.hash);
                iterator.remove();
            }
        }
    }

    protected abstract long toHashCode(byte[] var1);

    protected long toHashCode(long l) {
        return l;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("cache[count=%d], timeout[count=%d, positive=%d, negative=%d], ", this.cache.size(), this.timeoutQueue.size(), this.positiveTimeout, this.negativeTimeout));
        return stringBuilder.toString();
    }

    private static class TimeoutEntry {
        public final long hash;
        public final long timeout;

        public TimeoutEntry(long l, long l2) {
            this.hash = l;
            this.timeout = System.currentTimeMillis() + l2;
            if (this.timeout < 0L || this.timeout - System.currentTimeMillis() < 0L) {
                throw new IllegalStateException("timeout overflow " + l2);
            }
        }
    }
}

