/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.tcpip.Udp;

@Header(suite=ProtocolSuite.TCP_IP, description="Routing Information Protocol")
public abstract class Rip
extends JHeader {
    protected int count;

    @Bind(to=Udp.class)
    public static boolean bindToUdp(JPacket jPacket, Udp udp) {
        return udp.destination() == 520 || udp.source() == 520;
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        return jBuffer.size() - n;
    }

    @Field(offset=0, length=8)
    public int command() {
        return super.getUByte(0);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String commandDescription() {
        return this.commandEnum().toString();
    }

    public Command commandEnum() {
        return Command.valueOf(this.command());
    }

    public int count() {
        return this.count;
    }

    protected void decodeHeader() {
        this.count = (this.size() - 4) / 20;
    }

    @Field(offset=8, length=8)
    public int version() {
        return super.getUByte(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Command {
        REQUEST,
        REPLY,
        TRACE_ON,
        TRACE_OFF,
        SUN,
        TRIGGERED_REQUEST,
        TRIGGERED_RESPONSE,
        TRIGGERED_ACK,
        UPDATE_REQUEST,
        UPDATE_RESPONSE,
        UPDATE_ACK;


        public static Command valueOf(int n) {
            return n < Command.values().length ? Command.values()[n] : null;
        }
    }
}

