/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FlowKey;
import org.jnetpcap.packet.annotate.Header;

@Header(length=40)
public class Ip6
extends JHeader {
    public static final int ID = 3;

    @Field(offset=64, length=128, format="#ip6#")
    @FlowKey(index=0)
    public byte[] destination() {
        return this.getByteArray(24, 16);
    }

    public byte[] destinationToByteArray(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("address must be 16 byte long");
        }
        return this.getByteArray(24, byArray);
    }

    public int destinationToIntHash() {
        int n = 0;
        for (int i = 0; i < 16; i += 4) {
            n = (int)((long)n ^ super.getUInt(i + 24));
        }
        return n;
    }

    @Field(offset=12, length=20)
    public int flowLabel() {
        return this.getInt(0) & 0xFFFFF;
    }

    @Field(offset=56, length=8)
    public int hopLimit() {
        return this.getUByte(7);
    }

    @Field(offset=32, length=16)
    public int length() {
        return this.getUShort(4);
    }

    @Field(offset=48, length=8)
    @FlowKey(index=1)
    public int next() {
        return this.getUByte(6);
    }

    @Field(offset=64, length=128, format="#ip6#")
    @FlowKey(index=0)
    public byte[] source() {
        return this.getByteArray(8, 16);
    }

    public byte[] sourceToByteArray(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("address must be 16 byte long");
        }
        return this.getByteArray(8, byArray);
    }

    public int sourceToIntHash() {
        int n = 0;
        for (int i = 0; i < 16; i += 4) {
            n = (int)((long)n ^ super.getUInt(i + 8));
        }
        return n;
    }

    @Field(offset=4, length=8)
    public int trafficClass() {
        return this.getUShort(0) & 0xFFF;
    }

    public void trafficClass(int n) {
        int n2 = this.getUShort(0);
        this.setUShort(0, n &= 0xF);
    }

    @Field(offset=0, length=4)
    public int version() {
        return this.getUByte(0) >> 4;
    }

    public void version(int n) {
        int n2 = this.getUByte(0) & 0xF;
        this.setUByte(0, n2 |= (n & 0xF) << 4);
    }
}

