/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.util.Arrays;
import java.util.Comparator;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.format.JFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JField {
    private static final ThreadLocal<JFieldComp> SORT_BY_OFFSET = new ThreadLocal<JFieldComp>(){

        @Override
        protected JFieldComp initialValue() {
            return new JFieldComp();
        }
    };
    private JField parent;

    public static void sortFieldByOffset(JField[] jFieldArray, JHeader jHeader, boolean bl) {
        JFieldComp jFieldComp = SORT_BY_OFFSET.get();
        jFieldComp.setAscending(bl);
        jFieldComp.setHeader(jHeader);
        Arrays.sort(jFieldArray, jFieldComp);
    }

    public JField() {
        this.parent = null;
    }

    public JField(JField jField) {
        this.parent = jField;
    }

    public abstract String getDisplay(JHeader var1);

    public abstract int getLength(JHeader var1);

    public abstract long getMask(JHeader var1);

    public abstract String getName();

    public abstract String getNicname();

    public abstract int getOffset(JHeader var1);

    public JField getParent() {
        return this.parent;
    }

    public abstract JFormatter.Priority getPriority();

    public abstract JFormatter.Style getStyle();

    public abstract JField[] getSubFields();

    public abstract String getUnits(JHeader var1);

    public abstract <T> T getValue(Class<T> var1, JHeader var2);

    public abstract Object getValue(JHeader var1);

    public abstract String getValueDescription(JHeader var1);

    public abstract boolean hasField(JHeader var1);

    public abstract boolean hasSubFields();

    public abstract long longValue(JHeader var1);

    public final void setParent(JField jField) {
        this.parent = jField;
    }

    public abstract void setStyle(JFormatter.Style var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JFieldComp
    implements Comparator<JField> {
        private boolean ascending = true;
        private JHeader header;

        @Override
        public int compare(JField jField, JField jField2) {
            if (this.ascending) {
                return jField.getOffset(this.header) - jField2.getOffset(this.header);
            }
            return jField2.getOffset(this.header) - jField.getOffset(this.header);
        }

        public void setAscending(boolean bl) {
            this.ascending = bl;
        }

        public void setHeader(JHeader jHeader) {
            this.header = jHeader;
        }
    }
}

