/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import org.jnetpcap.nio.JMemoryReference;
import org.jnetpcap.nio.JStruct;
import org.jnetpcap.packet.JHeaderScanner;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScan;
import org.jnetpcap.packet.JScannerReference;

public class JScanner
extends JStruct {
    private static int count = 0;
    public static final int DEFAULT_BLOCKSIZE = 102400;
    private static ThreadLocal<JScanner> localScanners = new ThreadLocal<JScanner>(){

        @Override
        protected JScanner initialValue() {
            return new JScanner();
        }
    };
    public static final int MAX_ENTRY_COUNT = 64;
    public static final int MAX_ID_COUNT = 64;
    public static final String STRUCT_NAME = "scanner_t";

    public static void bindingOverride(int n, boolean bl) {
        if (bl) {
            JRegistry.setFlags(n, 2);
        } else {
            JRegistry.clearFlags(n, 2);
        }
        JPacket.getDefaultScanner().reloadAll();
    }

    public static JScanner getThreadLocal() {
        JScanner jScanner = JPacket.getDefaultScanner();
        return jScanner;
    }

    public static void shutdown() {
        localScanners.remove();
        localScanners = null;
    }

    public static void heuristicCheck(int n, boolean bl) {
        if (bl) {
            JRegistry.setFlags(n, 16);
        } else {
            JRegistry.clearFlags(n, 16);
        }
        JPacket.getDefaultScanner().reloadAll();
    }

    public static void heuristicPostCheck(int n, boolean bl) {
        if (bl) {
            JRegistry.setFlags(n, 16);
            JRegistry.clearFlags(n, 32);
        } else {
            JRegistry.clearFlags(n, 16);
            JRegistry.clearFlags(n, 32);
        }
        JPacket.getDefaultScanner().reloadAll();
    }

    public static void heuristicPreCheck(int n, boolean bl) {
        if (bl) {
            JRegistry.setFlags(n, 16);
            JRegistry.setFlags(n, 32);
        } else {
            JRegistry.clearFlags(n, 16);
            JRegistry.clearFlags(n, 32);
        }
        JPacket.getDefaultScanner().reloadAll();
    }

    private static native void initIds();

    public static void resetToDefaults() {
        for (int i = 0; i < 256; ++i) {
            JRegistry.clearFlags(i, -1);
        }
    }

    static native int sizeof();

    private static long toBitMask(int ... nArray) {
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    public JScanner() {
        this(102400);
    }

    public JScanner(int n) {
        super("scanner_t#" + count++, n + JScanner.sizeof());
        this.init(new JScan());
        this.reloadAll();
    }

    public native long getFrameNumber();

    private native void init(JScan var1);

    private native void loadFlags(int[] var1);

    private native void loadScanners(JHeaderScanner[] var1);

    public void reloadAll() {
        JHeaderScanner[] jHeaderScannerArray = JRegistry.getHeaderScanners();
        for (int i = 0; i < jHeaderScannerArray.length; ++i) {
            if (jHeaderScannerArray[i] == null || jHeaderScannerArray[i].hasBindings() || jHeaderScannerArray[i].hasScanMethod() || !jHeaderScannerArray[i].isDirect()) continue;
            jHeaderScannerArray[i] = null;
        }
        this.loadScanners(jHeaderScannerArray);
        int[] nArray = JRegistry.getAllFlags();
        this.loadFlags(nArray);
    }

    public int scan(JPacket jPacket, int n) {
        return this.scan(jPacket, n, jPacket.getPacketWirelen());
    }

    public int scan(JPacket jPacket, int n, int n2) {
        JPacket.State state = jPacket.getState();
        return this.scan(jPacket, state, n, n2);
    }

    private native int scan(JPacket var1, JPacket.State var2, int var3, int var4);

    public native void setFrameNumber(long var1);

    protected JMemoryReference createReference(long l, long l2) {
        return new JScannerReference(this, l, l2);
    }

    static {
        try {
            JScanner.initIds();
        }
        catch (Exception exception) {
            System.err.println("JScanner.static: error=" + exception.toString());
            throw new ExceptionInInitializerError(exception);
        }
    }
}

