/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JMappedHeader;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.util.JThreadLocal;

public abstract class AbstractMessageHeader
extends JMappedHeader {
    private static final char[] HEADER_DELIMITER = new char[]{'\r', '\n', '\r', '\n'};
    private static final String[] VALID_CHARS = new String[]{"GET", "PUT", "POS", "CON", "CAN", "HEA", "HTT", "OPT", "DEL", "TRA", "SIP", "INV", "REG", "ACK", "BYE", "REF", "NOT", "INF", "PRA", "UPD", "SUB", "PUB", "MES"};
    private MessageType messageType;
    private final JThreadLocal<StringBuilder> stringLocal = new JThreadLocal<StringBuilder>(StringBuilder.class);
    protected String rawHeader;

    private static boolean checkValidFirstChars(JBuffer jBuffer, int n) {
        String string = jBuffer.getUTF8String(n, 3);
        for (String string2 : VALID_CHARS) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        if (!AbstractMessageHeader.checkValidFirstChars(jBuffer, n)) {
            return 0;
        }
        int n2 = jBuffer.findUTF8String(n, HEADER_DELIMITER);
        return n2;
    }

    protected abstract void decodeFirstLine(String var1);

    protected void decodeHeader() {
        super.clearFields();
        StringBuilder stringBuilder = (StringBuilder)this.stringLocal.get();
        stringBuilder.setLength(0);
        int n = super.getLength();
        super.getUTF8String(0, stringBuilder, n);
        this.rawHeader = stringBuilder.toString();
        String[] stringArray = this.rawHeader.split("\r\n|\n");
        stringBuilder.setLength(0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.length() == 0) continue;
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') {
                string = string.trim();
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(string);
                continue;
            }
            if (stringBuilder.length() != 0) {
                string = stringBuilder.toString();
                stringBuilder.setLength(0);
                --i;
            }
            String[] stringArray2 = string.split(":", 2);
            if (i == 0) {
                if (stringArray2[0].length() <= 0) continue;
                this.decodeFirstLine(string);
                continue;
            }
            if (stringArray2.length < 2) continue;
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            int n2 = this.rawHeader.indexOf(string2 + ":");
            int n3 = string2.length() + string3.length() + 1;
            super.addField(this.map(string2.trim()), string3.trim(), n2, n3);
        }
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        REQUEST,
        RESPONSE;

    }
}

