/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.io.IOException;
import java.io.InputStream;
import org.jnetpcap.nio.JBuffer;

public class JBufferInputStream
extends InputStream {
    private final JBuffer in;
    private int position;
    private final int end;
    private int mark = -1;

    public JBufferInputStream(JBuffer jBuffer) {
        this(jBuffer, 0, jBuffer.size());
    }

    public JBufferInputStream(JBuffer jBuffer, int n, int n2) {
        n2 = n + n2 > jBuffer.size() ? jBuffer.size() - n : n2;
        this.in = jBuffer;
        this.position = n;
        this.end = n + n2;
    }

    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.in.getUByte(this.position++);
    }

    public int available() throws IOException {
        return this.end - this.position;
    }

    public void close() throws IOException {
        this.position = this.end;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.max(n2);
        this.in.getByteArray(this.position, byArray, n, n3);
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        long l2 = this.max((int)l);
        this.position += this.max((int)l);
        return l2;
    }

    public synchronized void mark(int n) {
        this.mark = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        if (this.mark != -1) {
            this.position = this.mark;
            this.mark = -1;
        }
    }

    private int max(int n) {
        int n2 = this.end - this.position;
        int n3 = n > n2 ? n2 : n;
        return n3;
    }
}

