/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import org.jnetpcap.Pcap;
import org.jnetpcap.packet.format.FormatUtils;

@Library(preload={Pcap.class}, jni={"jnetpcap"})
public class PcapSockAddr {
    public static final int AF_INET = 2;
    public static final int AF_INET6 = 23;
    private volatile short family;
    private volatile byte[] data;

    @LibraryInitializer
    private static native void initIDs();

    public final short getFamily() {
        return this.family;
    }

    public final byte[] getData() {
        return this.data;
    }

    private int u(byte n) {
        return n >= 0 ? n : n + 256;
    }

    public String toString() {
        switch (this.family) {
            case 2: {
                return "[INET4:" + FormatUtils.ip(this.data) + "]";
            }
            case 23: {
                return "[INET6:" + FormatUtils.ip(this.data) + "]";
            }
        }
        return "[" + this.family + "]";
    }

    static {
        JNILibrary.register(PcapSockAddr.class);
    }
}

