/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.library;

import com.slytechs.library.JNIFormat;
import com.slytechs.library.LibraryMember;
import com.slytechs.library.NativeLibrary;
import com.slytechs.library.NativeSymbol;
import java.lang.reflect.Method;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNISymbol
extends NativeSymbol {
    static final JNISymbol NOT_FOUND_SYMBOL;
    public final Class<?> clazz;
    public final String javaName;
    public final String jniSignature;
    public final Method method;
    public final boolean foundAllSymbols;
    public final NativeSymbol[] natives;

    static native void registerSymbol(Class<?> var0, long var1, String var3, String var4);

    public static String toJNIName(Method method) {
        return JNIFormat.jniMethodName(method);
    }

    public static String toJNINameAndSignature(Method method) {
        return JNIFormat.jniMethodNameAndSignature(method);
    }

    public static String toJNISignature(Method method) {
        return JNIFormat.jniParenSignature(method);
    }

    JNISymbol(String string, long l, Method method, String string2) {
        super(string, l, System.mapLibraryName(string2));
        this.clazz = method.getDeclaringClass();
        this.method = method;
        this.javaName = method.getName();
        this.jniSignature = JNIFormat.jniParenSignature(method);
        LinkedList<NativeSymbol> linkedList = new LinkedList<NativeSymbol>();
        LibraryMember libraryMember = method.getAnnotation(LibraryMember.class);
        boolean bl = true;
        if (libraryMember != null) {
            for (String string3 : libraryMember.value()) {
                NativeSymbol nativeSymbol = NativeLibrary.findSymbol(string3);
                if (!nativeSymbol.isFound() && bl) {
                    bl = false;
                }
                linkedList.add(nativeSymbol);
            }
        }
        this.natives = linkedList.toArray(new NativeSymbol[linkedList.size()]);
        this.foundAllSymbols = bl;
    }

    public void register() {
    }

    public boolean isLoaded() {
        return this.address != 0L && this.foundAllSymbols;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.libName).append("::").append(this.nativeName);
        if (this.method != null) {
            stringBuilder.append(!this.nativeName.contains("__") ? this.jniSignature : "(...)");
        }
        stringBuilder.append("@0x").append(Long.toString(this.address, 16));
        if (this.natives.length != 0) {
            stringBuilder.append("[");
            int n = stringBuilder.length();
            for (NativeSymbol nativeSymbol : this.natives) {
                stringBuilder.append(stringBuilder.length() != n ? ", " : "");
                stringBuilder.append(nativeSymbol.toString());
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    static {
        JNISymbol jNISymbol = null;
        try {
            Method method = Class.class.getMethod("forName", String.class);
            jNISymbol = new JNISymbol("", 0L, method, "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        NOT_FOUND_SYMBOL = jNISymbol;
    }
}

