/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import java.util.Map;
import org.ops4j.pax.logging.OSGIPaxLoggingManager;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.osgi.framework.BundleContext;
import org.slf4j.spi.MDCAdapter;

public class Slf4jMDCAdapter
implements MDCAdapter {
    private static PaxContext m_context;
    private static PaxContext m_defaultContext;
    private static PaxLoggingManager m_paxLogging;

    public static void setBundleContext(BundleContext ctx) {
        m_paxLogging = new OSGIPaxLoggingManager(ctx);
        m_paxLogging.open();
    }

    private static PaxContext getContext() {
        if (m_context == null && m_paxLogging != null) {
            m_context = m_paxLogging.getPaxLoggingService() != null ? m_paxLogging.getPaxLoggingService().getPaxContext() : null;
        }
        return m_context != null ? m_context : m_defaultContext;
    }

    public void put(String key, String val) {
        Slf4jMDCAdapter.getContext().put(key, val);
    }

    public String get(String key) {
        Object value = null;
        value = Slf4jMDCAdapter.getContext().get(key);
        return value != null ? value.toString() : null;
    }

    public void remove(String key) {
        Slf4jMDCAdapter.getContext().remove(key);
    }

    public void clear() {
        Slf4jMDCAdapter.getContext().clear();
    }

    public Map getCopyOfContextMap() {
        return Slf4jMDCAdapter.getContext().getCopyOfContextMap();
    }

    public void setContextMap(Map contextMap) {
        Slf4jMDCAdapter.getContext().setContextMap(contextMap);
    }

    public static void dispose() {
        m_paxLogging.close();
        m_paxLogging.dispose();
        m_paxLogging = null;
    }

    static {
        m_defaultContext = new PaxContext();
    }
}

