/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.types;

import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.GrammarUriContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.BinaryBase64Datatype;
import com.siemens.ct.exi.datatype.BinaryHexDatatype;
import com.siemens.ct.exi.datatype.BooleanDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.DatetimeDatatype;
import com.siemens.ct.exi.datatype.DecimalDatatype;
import com.siemens.ct.exi.datatype.FloatDatatype;
import com.siemens.ct.exi.datatype.IntegerDatatype;
import com.siemens.ct.exi.datatype.StringDatatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.grammars.Grammars;
import com.siemens.ct.exi.types.BuiltIn;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.types.TypeCoder;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractRepresentationMapTypeCoder
implements TypeCoder {
    protected final Grammars grammar;
    protected Map<QName, Datatype> dtrMap;
    protected Datatype recentDtrDataype;
    protected final QNameContext qncXsdInteger;

    public AbstractRepresentationMapTypeCoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Grammars grammar) throws EXIException {
        this.grammar = grammar;
        this.dtrMap = new HashMap<QName, Datatype>();
        GrammarContext gc = grammar.getGrammarContext();
        this.qncXsdInteger = gc.getGrammarUriContext(BuiltIn.XSD_INTEGER.getNamespaceURI()).getQNameContext(BuiltIn.XSD_INTEGER.getLocalPart());
        assert (dtrMapTypes.length == dtrMapRepresentations.length);
        int i = 0;
        while (i < dtrMapTypes.length) {
            QNameContext qncType;
            Datatype representation = this.getDatatypeRepresentation(dtrMapRepresentations[i]);
            QName type = dtrMapTypes[i];
            GrammarUriContext guc = gc.getGrammarUriContext(type.getNamespaceURI());
            if (guc != null && (qncType = guc.getQNameContext(type.getLocalPart())) != null) {
                this.registerDatatype(representation, qncType, dtrMapTypes);
            }
            ++i;
        }
    }

    protected Datatype getRecentDtrMapDatatype() {
        return this.recentDtrDataype;
    }

    private boolean isDerivedFrom(QNameContext type, QNameContext ancestor) {
        if (type.equals(ancestor)) {
            return true;
        }
        List<QNameContext> subtypes = ancestor.getSimpleTypeSubtypes();
        if (subtypes != null) {
            for (QNameContext subtype : subtypes) {
                if (!this.isDerivedFrom(type, subtype)) continue;
                return true;
            }
        }
        return false;
    }

    protected void registerDatatype(Datatype representation, QNameContext type, QName[] dtrMapTypes) {
        boolean isDerivedFromXsdInteger;
        if (representation.getBuiltInType() == BuiltInType.INTEGER && (isDerivedFromXsdInteger = this.isDerivedFrom(type, this.qncXsdInteger))) {
            return;
        }
        this.dtrMap.put(type.getQName(), representation);
        List<QNameContext> subtypes = type.getSimpleTypeSubtypes();
        if (subtypes != null) {
            for (QNameContext qncSubtype : subtypes) {
                QName subtype = qncSubtype.getQName();
                if (BuiltIn.XSD_BASE64BINARY.equals(subtype) || BuiltIn.XSD_HEXBINARY.equals(subtype) || BuiltIn.XSD_BOOLEAN.equals(subtype) || BuiltIn.XSD_DATETIME.equals(subtype) || BuiltIn.XSD_TIME.equals(subtype) || BuiltIn.XSD_DATE.equals(subtype) || BuiltIn.XSD_GYEARMONTH.equals(subtype) || BuiltIn.XSD_GYEAR.equals(subtype) || BuiltIn.XSD_GMONTHDAY.equals(subtype) || BuiltIn.XSD_GDAY.equals(subtype) || BuiltIn.XSD_GMONTH.equals(subtype) || BuiltIn.XSD_DECIMAL.equals(subtype) || BuiltIn.XSD_FLOAT.equals(subtype) || BuiltIn.XSD_DOUBLE.equals(subtype) || BuiltIn.XSD_INTEGER.equals(subtype) || BuiltIn.XSD_STRING.equals(subtype) || BuiltIn.XSD_ANY_SIMPLE_TYPE.equals(subtype) || this.contains(qncSubtype, dtrMapTypes)) continue;
                this.registerDatatype(representation, qncSubtype, dtrMapTypes);
            }
        }
    }

    protected boolean contains(QNameContext q, QName[] qnames) {
        QName[] qNameArray = qnames;
        int n = qnames.length;
        int n2 = 0;
        while (n2 < n) {
            QName qn = qNameArray[n2];
            if (qn.equals(q.getQName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Datatype getDatatypeRepresentation(QName representation) throws EXIException {
        try {
            void var2_17;
            Object var2_2 = null;
            if ("http://www.w3.org/2009/exi".equals(representation.getNamespaceURI())) {
                String localPart = representation.getLocalPart();
                if ("base64Binary".equals(localPart)) {
                    BinaryBase64Datatype binaryBase64Datatype = new BinaryBase64Datatype(null);
                    return var2_17;
                } else if ("hexBinary".equals(localPart)) {
                    BinaryHexDatatype binaryHexDatatype = new BinaryHexDatatype(null);
                    return var2_17;
                } else if ("boolean".equals(localPart)) {
                    BooleanDatatype booleanDatatype = new BooleanDatatype(null);
                    return var2_17;
                } else if ("dateTime".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.dateTime, null);
                    return var2_17;
                } else if ("time".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.time, null);
                    return var2_17;
                } else if ("date".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.date, null);
                    return var2_17;
                } else if ("gYearMonth".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonthDay, null);
                    return var2_17;
                } else if ("gDay".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gDay, null);
                    return var2_17;
                } else if ("gMonth".equals(localPart)) {
                    DatetimeDatatype datetimeDatatype = new DatetimeDatatype(DateTimeType.gMonth, null);
                    return var2_17;
                } else if ("decimal".equals(localPart)) {
                    DecimalDatatype decimalDatatype = new DecimalDatatype(null);
                    return var2_17;
                } else if ("double".equals(localPart)) {
                    FloatDatatype floatDatatype = new FloatDatatype(null);
                    return var2_17;
                } else if ("integer".equals(localPart)) {
                    IntegerDatatype integerDatatype = new IntegerDatatype(null);
                    return var2_17;
                } else {
                    if (!"string".equals(localPart)) throw new EXIException("[EXI] Unsupported datatype representation: " + representation);
                    StringDatatype stringDatatype = new StringDatatype(null);
                }
                return var2_17;
            } else {
                String className = QNameUtilities.getClassName(representation);
                Class<?> c = Class.forName(className);
                Object o = c.newInstance();
                if (!(o instanceof Datatype)) throw new Exception("[EXI] no Datatype instance");
                Datatype datatype = (Datatype)o;
            }
            return var2_17;
        }
        catch (Exception exception) {
            throw new EXIException(exception);
        }
    }
}

