/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.DateTimeValue;
import com.siemens.ct.exi.values.DecimalValue;
import com.siemens.ct.exi.values.FloatValue;
import com.siemens.ct.exi.values.IntegerValue;
import java.io.IOException;
import java.math.BigInteger;

public abstract class AbstractDecoderChannel
implements DecoderChannel {
    private final int[] maskedOctets = new int[9];
    private static final int MAX_OCTETS_FOR_LONG = 9;
    protected StringBuilder sbHelper;

    public BooleanValue decodeBooleanValue() throws IOException {
        return new BooleanValue(this.decodeBoolean());
    }

    public char[] decodeString() throws IOException {
        return this.decodeStringOnly(this.decodeUnsignedInteger());
    }

    public char[] decodeStringOnly(int length) throws IOException {
        char[] ca = new char[length];
        int i = 0;
        while (i < length) {
            int b = this.decode();
            if (b < 128) {
                ca[i] = (char)b;
            } else {
                int codePoint = this.decodeUnsignedIntegerBytePreread(b);
                if (Character.isSupplementaryCodePoint(codePoint)) {
                    return this.decodeStringOnlySupplementaryCodePoints(ca, length, i, codePoint);
                }
                ca[i] = (char)codePoint;
            }
            ++i;
        }
        return ca;
    }

    private char[] decodeStringOnlySupplementaryCodePoints(char[] ca, int length, int i, int codePoint) throws IOException {
        assert (Character.isSupplementaryCodePoint(codePoint));
        if (this.sbHelper == null) {
            this.sbHelper = new StringBuilder();
        } else {
            this.sbHelper.setLength(0);
        }
        this.sbHelper.append(ca, 0, i);
        this.sbHelper.appendCodePoint(codePoint);
        int k = i + 1;
        while (k < length) {
            this.sbHelper.appendCodePoint(this.decodeUnsignedInteger());
            ++k;
        }
        int len = this.sbHelper.length();
        char[] dst = new char[len];
        this.sbHelper.getChars(0, len, dst, 0);
        return dst;
    }

    public int decodeUnsignedInteger() throws IOException {
        int b = this.decode();
        return b < 128 ? b : this.decodeUnsignedIntegerBytePreread(b);
    }

    private int decodeUnsignedIntegerBytePreread(int b) throws IOException {
        assert (b > 127);
        int result = b & 0x7F;
        int mShift = 7;
        do {
            b = this.decode();
            result += (b & 0x7F) << mShift;
            mShift += 7;
        } while (b > 127);
        return result;
    }

    protected long decodeUnsignedLong() throws IOException {
        int b;
        long lResult = 0L;
        int mShift = 0;
        do {
            b = this.decode();
            lResult += (long)(b & 0x7F) << mShift;
            mShift += 7;
        } while (b >>> 7 == 1);
        return lResult;
    }

    protected int decodeInteger() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedInteger() + 1);
        }
        return this.decodeUnsignedInteger();
    }

    protected long decodeLong() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedLong() + 1L);
        }
        return this.decodeUnsignedLong();
    }

    public IntegerValue decodeIntegerValue() throws IOException {
        return this.decodeUnsignedIntegerValue(this.decodeBoolean());
    }

    public IntegerValue decodeUnsignedIntegerValue() throws IOException {
        return this.decodeUnsignedIntegerValue(false);
    }

    protected final IntegerValue decodeUnsignedIntegerValue(boolean negative) throws IOException {
        int b;
        int i = 0;
        while (i < 9) {
            b = this.decode();
            if (b < 128) {
                switch (i) {
                    case 0: {
                        return IntegerValue.valueOf(negative ? -(b + 1) : b);
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.maskedOctets[i] = b;
                        int iResult = 0;
                        int k = i;
                        while (k >= 0) {
                            iResult = iResult << 7 | this.maskedOctets[k];
                            --k;
                        }
                        if (negative) {
                            iResult = -(iResult + 1);
                        }
                        return IntegerValue.valueOf(iResult);
                    }
                }
                this.maskedOctets[i] = b;
                long lResult = 0L;
                int k = i;
                while (k >= 0) {
                    lResult = lResult << 7 | (long)this.maskedOctets[k];
                    --k;
                }
                if (negative) {
                    lResult = -(lResult + 1L);
                }
                return IntegerValue.valueOf(lResult);
            }
            this.maskedOctets[i] = b & 0x7F;
            ++i;
        }
        BigInteger bResult = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        int i2 = 0;
        while (i2 < 9) {
            bResult = bResult.add(multiplier.multiply(BigInteger.valueOf(this.maskedOctets[i2])));
            multiplier = multiplier.shiftLeft(7);
            ++i2;
        }
        do {
            b = this.decode();
            bResult = bResult.add(multiplier.multiply(BigInteger.valueOf(b & 0x7F)));
            multiplier = multiplier.shiftLeft(7);
        } while (b > 127);
        if (negative) {
            bResult = bResult.add(BigInteger.ONE).negate();
        }
        return IntegerValue.valueOf(bResult);
    }

    public IntegerValue decodeNBitUnsignedIntegerValue(int n) throws IOException {
        return IntegerValue.valueOf(this.decodeNBitUnsignedInteger(n));
    }

    public DecimalValue decodeDecimalValue() throws IOException {
        boolean negative = this.decodeBoolean();
        IntegerValue integral = this.decodeUnsignedIntegerValue(false);
        IntegerValue revFractional = this.decodeUnsignedIntegerValue(false);
        return new DecimalValue(negative, integral, revFractional);
    }

    public FloatValue decodeFloatValue() throws IOException {
        return new FloatValue(this.decodeIntegerValue(), this.decodeIntegerValue());
    }

    public DateTimeValue decodeDateTimeValue(DateTimeType type) throws IOException {
        int year = 0;
        int monthDay = 0;
        int time = 0;
        int fractionalSecs = 0;
        boolean presenceFractionalSecs = false;
        switch (type) {
            case gYear: {
                year = this.decodeInteger() + 2000;
                break;
            }
            case gYearMonth: 
            case date: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
                break;
            }
            case dateTime: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
            }
            case time: {
                time = this.decodeNBitUnsignedInteger(17);
                presenceFractionalSecs = this.decodeBoolean();
                fractionalSecs = presenceFractionalSecs ? this.decodeUnsignedInteger() : 0;
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                monthDay = this.decodeNBitUnsignedInteger(9);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean presenceTimezone = this.decodeBoolean();
        int timeZone = presenceTimezone ? this.decodeNBitUnsignedInteger(11) - 896 : 0;
        return new DateTimeValue(type, year, monthDay, time, presenceFractionalSecs, fractionalSecs, presenceTimezone, timeZone);
    }
}

