/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class BitInputStream {
    public static final int BUFFER_CAPACITY = 8;
    private int capacity = 0;
    private int buffer = 0;
    private InputStream istream;

    public BitInputStream(InputStream istream) {
        this.istream = istream;
    }

    public void setInputStream(InputStream istream) {
        this.istream = istream;
        this.capacity = 0;
        this.buffer = 0;
    }

    private final void readBuffer() throws IOException {
        this.buffer = this.istream.read();
        if (this.buffer == -1) {
            throw new EOFException("Premature EOS found while reading data.");
        }
        this.capacity = 8;
    }

    public void align() throws IOException {
        if (this.capacity != 0) {
            this.capacity = 0;
        }
    }

    public int lookAhead() throws IOException {
        if (this.capacity == 0) {
            this.readBuffer();
        }
        return this.buffer;
    }

    public void skip(long n) throws IOException {
        if (this.capacity == 0) {
            while (n != 0L) {
                n -= this.istream.skip(n);
            }
        } else {
            int i = 0;
            while ((long)i < n) {
                this.readBits(8);
                ++n;
            }
        }
    }

    public int readBit() throws IOException {
        if (this.capacity == 0) {
            this.readBuffer();
        }
        return this.buffer >> --this.capacity & 1;
    }

    public int readBits(int n) throws IOException {
        assert (n > 0);
        if (n <= this.capacity) {
            return this.buffer >> (this.capacity -= n) & 255 >> 8 - n;
        }
        int result = this.buffer & 255 >> 8 - this.capacity;
        n -= this.capacity;
        this.capacity = 0;
        while (n > 7) {
            if (this.capacity == 0) {
                this.readBuffer();
            }
            result = result << 8 | this.buffer;
            n -= 8;
            this.capacity = 0;
        }
        if (n > 0) {
            if (this.capacity == 0) {
                this.readBuffer();
            }
            result = result << n | this.buffer >>> 8 - n;
            this.capacity = 8 - n;
        }
        return result;
    }

    public void read(byte[] b, int off, int len) throws IOException {
        if (len != 0) {
            if (this.capacity == 0) {
                int readBytes = 0;
                while ((readBytes += this.istream.read(b, readBytes, len - readBytes)) < len) {
                }
            } else {
                int readBytes = 0;
                int shift1 = 8 - this.capacity;
                int shift2 = this.capacity;
                int currentResult = this.buffer & 255 >> shift1;
                int lenMinusOne = len - 1;
                byte[] fullBytes = new byte[lenMinusOne];
                while ((readBytes += this.istream.read(fullBytes, readBytes, lenMinusOne - readBytes)) < lenMinusOne) {
                }
                int i = 0;
                while (i < lenMinusOne) {
                    b[i] = (byte)(currentResult << shift1 | (0xFF & fullBytes[i]) >>> shift2);
                    currentResult = fullBytes[i] & 255 >> shift1;
                    ++i;
                }
                this.readBuffer();
                currentResult = currentResult << shift1 | this.buffer >>> shift2;
                b[off + len - 1] = (byte)currentResult;
                this.capacity = shift2;
            }
        }
    }

    public final int readDirectByte() throws IOException {
        return this.istream.read();
    }
}

