/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.grammar;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.EndElement;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.event.StartElementGeneric;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedElement;
import com.siemens.ct.exi.grammars.grammar.SchemaInformedGrammar;
import com.siemens.ct.exi.grammars.production.Production;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammar
implements Grammar {
    private static final long serialVersionUID = -1626120406315756322L;
    protected static final SchemaInformedGrammar END_RULE = new SchemaInformedElement();
    protected static final Event START_ELEMENT_GENERIC;
    protected static final Event END_ELEMENT;
    protected String label = null;

    static {
        END_RULE.setLabel("<END>");
        START_ELEMENT_GENERIC = new StartElementGeneric();
        END_ELEMENT = new EndElement();
    }

    public AbstractGrammar() {
    }

    public AbstractGrammar(String label) {
        this();
        this.label = label;
    }

    public void addTerminalProduction(Event event) {
        assert (event.isEventType(EventType.END_ELEMENT) || event.isEventType(EventType.END_DOCUMENT));
        this.addProduction(event, END_RULE);
    }

    @Override
    public void learnStartElement(StartElement se) {
    }

    @Override
    public void learnEndElement() {
    }

    @Override
    public void learnAttribute(Attribute at) {
    }

    @Override
    public void learnCharacters() {
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null && !this.label.equals("")) {
            return this.label;
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.hashCode() + "]";
    }

    @Override
    public int get3rdLevelCharacteristics(FidelityOptions fidelityOptions) {
        int ch3 = 0;
        if (!fidelityOptions.isStrict()) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                ++ch3;
            }
            if (fidelityOptions.isFidelityEnabled("PRESERVE_PIS")) {
                ++ch3;
            }
        }
        return ch3;
    }

    @Override
    public int get3rdLevelEventCode(EventType eventType, FidelityOptions fidelityOptions) {
        int ec3 = -1;
        if (!fidelityOptions.isStrict()) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                if (EventType.COMMENT == eventType) {
                    ec3 = 0;
                } else if (EventType.PROCESSING_INSTRUCTION == eventType) {
                    ec3 = 1;
                }
            } else if (fidelityOptions.isFidelityEnabled("PRESERVE_PIS") && EventType.PROCESSING_INSTRUCTION == eventType) {
                ec3 = 0;
            }
        }
        return ec3;
    }

    @Override
    public EventType get3rdLevelEventType(int eventCode, FidelityOptions fidelityOptions) {
        if (eventCode == 0) {
            if (fidelityOptions.isFidelityEnabled("PRESERVE_COMMENTS")) {
                return EventType.COMMENT;
            }
            return EventType.PROCESSING_INSTRUCTION;
        }
        return EventType.PROCESSING_INSTRUCTION;
    }

    protected static int getEventCode(EventType eventType, List<EventType> events) {
        int i = 0;
        while (i < events.size()) {
            if (events.get(i).equals((Object)eventType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Grammar getElementContentGrammar() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Grammar) {
            Grammar gr = (Grammar)obj;
            int numberOfEvents = gr.getNumberOfEvents();
            if (this.getNumberOfEvents() == numberOfEvents) {
                int i = 0;
                while (i < numberOfEvents) {
                    Production ei = gr.getProduction(i);
                    if (!ei.getEvent().equals(this.getProduction(i).getEvent())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected static boolean checkQualifiedName(QName c, String namespaceURI, String localName) {
        return c.getLocalPart().equals(localName) && c.getNamespaceURI().equals(namespaceURI);
    }
}

