/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype.strings;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.StringValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class StringDecoderImpl
implements StringDecoder {
    protected List<StringValue> globalValues;
    protected boolean localValuePartitions;

    public StringDecoderImpl(boolean localValuePartitions) {
        this.localValuePartitions = localValuePartitions;
        this.globalValues = new ArrayList<StringValue>();
    }

    public StringValue readValue(DecoderContext coder, QNameContext context, DecoderChannel valueChannel) throws IOException {
        StringValue value;
        int i = valueChannel.decodeUnsignedInteger();
        switch (i) {
            case 0: {
                if (this.localValuePartitions) {
                    value = this.readValueLocalHit(coder, context, valueChannel);
                    break;
                }
                throw new IOException("EXI stream contains local-value hit even though profile options indicate otherwise.");
            }
            case 1: {
                value = this.readValueGlobalHit(valueChannel);
                break;
            }
            default: {
                int L = i - 2;
                if (L > 0) {
                    value = new StringValue(valueChannel.decodeStringOnly(L));
                    this.addValue(coder, context, value);
                    break;
                }
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        assert (value != null);
        return value;
    }

    public StringValue readValueLocalHit(DecoderContext coder, QNameContext context, DecoderChannel valueChannel) throws IOException {
        assert (this.localValuePartitions);
        int n = MethodsBag.getCodingLength(coder.getNumberOfStringValues(context));
        int localID = valueChannel.decodeNBitUnsignedInteger(n);
        return coder.getStringValue(context, localID);
    }

    public StringValue readValueGlobalHit(DecoderChannel valueChannel) throws IOException {
        int n = MethodsBag.getCodingLength(this.globalValues.size());
        int globalID = valueChannel.decodeNBitUnsignedInteger(n);
        return this.globalValues.get(globalID);
    }

    public void addValue(DecoderContext coder, QNameContext context, StringValue value) {
        assert (!this.globalValues.contains(value));
        this.globalValues.add(value);
        if (this.localValuePartitions) {
            coder.addStringValue(context, value);
        }
    }

    public void clear() {
        this.globalValues.clear();
    }
}

