/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class UnsignedIntegerDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = 8260894749324499802L;
    protected IntegerValue lastUnsignedInteger;

    public UnsignedIntegerDatatype(QName schemaType) {
        super(BuiltInType.UNSIGNED_INTEGER, schemaType);
        this.rcs = new XSDIntegerCharacterSet();
    }

    protected boolean isValidString(String value) {
        this.lastUnsignedInteger = IntegerValue.parse(value);
        if (this.lastUnsignedInteger != null) {
            return this.lastUnsignedInteger.isPositive();
        }
        return false;
    }

    public boolean isValid(Value value) {
        if (value instanceof IntegerValue) {
            this.lastUnsignedInteger = (IntegerValue)value;
            return this.lastUnsignedInteger.isPositive();
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeUnsignedIntegerValue(this.lastUnsignedInteger);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        return valueChannel.decodeUnsignedIntegerValue();
    }
}

