/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringCoder;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.StringValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class RestrictedCharacterSetDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -6098764255799006920L;
    protected String lastValidValue;

    public RestrictedCharacterSetDatatype(RestrictedCharacterSet rcs, QName schemaType) {
        this(schemaType);
        this.rcs = rcs;
    }

    public RestrictedCharacterSetDatatype(QName schemaType) {
        super(BuiltInType.RCS_STRING, schemaType);
    }

    public void setRestrictedCharacterSet(RestrictedCharacterSet rcs) {
        this.rcs = rcs;
    }

    public RestrictedCharacterSet getRestrictedCharacterSet() {
        return this.rcs;
    }

    public boolean isValid(Value value) {
        this.lastValidValue = value.toString();
        return true;
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        StringEncoder stringEncoder = encoderContext.getStringEncoder();
        if (stringEncoder.isStringHit(this.lastValidValue)) {
            stringEncoder.writeValue(encoderContext, qnContext, valueChannel, this.lastValidValue);
        } else {
            int L = this.lastValidValue.length();
            valueChannel.encodeUnsignedInteger(L + 2);
            if (L > 0) {
                int numberOfBits = this.rcs.getCodingLength();
                int i = 0;
                while (i < L) {
                    int codePoint = this.lastValidValue.codePointAt(i);
                    int code = this.rcs.getCode(codePoint);
                    if (code == -1) {
                        valueChannel.encodeNBitUnsignedInteger(this.rcs.size(), numberOfBits);
                        valueChannel.encodeUnsignedInteger(codePoint);
                    } else {
                        valueChannel.encodeNBitUnsignedInteger(code, numberOfBits);
                    }
                    ++i;
                }
                stringEncoder.addValue(encoderContext, qnContext, this.lastValidValue);
            }
        }
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        StringValue value;
        StringDecoder stringDecoder = decoderContext.getStringDecoder();
        int i = valueChannel.decodeUnsignedInteger();
        if (i == 0) {
            value = stringDecoder.readValueLocalHit(decoderContext, qnContext, valueChannel);
        } else if (i == 1) {
            value = stringDecoder.readValueGlobalHit(valueChannel);
        } else {
            int L = i - 2;
            if (L > 0) {
                int numberOfBits = this.rcs.getCodingLength();
                int size = this.rcs.size();
                char[] cValue = new char[L];
                value = new StringValue(cValue);
                int k = 0;
                while (k < L) {
                    int code = valueChannel.decodeNBitUnsignedInteger(numberOfBits);
                    int codePoint = code == size ? valueChannel.decodeUnsignedInteger() : this.rcs.getCodePoint(code);
                    Character.toChars(codePoint, cValue, k);
                    ++k;
                }
                stringDecoder.addValue(decoderContext, qnContext, value);
            } else {
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        return value;
    }
}

