/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class NBitUnsignedIntegerDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -7109188105049008275L;
    protected IntegerValue validValue;
    protected final IntegerValue lowerBound;
    protected final IntegerValue upperBound;
    protected final int numberOfBits4Range;

    public NBitUnsignedIntegerDatatype(IntegerValue lowerBound, IntegerValue upperBound, QName schemaType) {
        super(BuiltInType.NBIT_UNSIGNED_INTEGER, schemaType);
        this.rcs = new XSDIntegerCharacterSet();
        assert (upperBound.compareTo(lowerBound) >= 0);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        IntegerValue diff = upperBound.subtract(lowerBound);
        this.numberOfBits4Range = MethodsBag.getCodingLength(diff.intValue() + 1);
    }

    public IntegerValue getLowerBound() {
        return this.lowerBound;
    }

    public IntegerValue getUpperBound() {
        return this.upperBound;
    }

    public int getNumberOfBits() {
        return this.numberOfBits4Range;
    }

    protected boolean isValidString(String value) {
        this.validValue = IntegerValue.parse(value);
        if (this.validValue == null) {
            return false;
        }
        return this.checkBounds();
    }

    public boolean isValid(Value value) {
        if (value instanceof IntegerValue) {
            this.validValue = (IntegerValue)value;
            return this.checkBounds();
        }
        return this.isValidString(value.toString());
    }

    protected boolean checkBounds() {
        return this.validValue.compareTo(this.lowerBound) >= 0 && this.validValue.compareTo(this.upperBound) <= 0;
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        IntegerValue iv = this.validValue.subtract(this.lowerBound);
        valueChannel.encodeNBitUnsignedInteger(iv.intValue(), this.numberOfBits4Range);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        IntegerValue iv = valueChannel.decodeNBitUnsignedIntegerValue(this.numberOfBits4Range);
        return iv.add(this.lowerBound);
    }
}

