/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.ListValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class ListDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = 1329094446386886766L;
    private Datatype listDatatype;
    ListValue listValues;

    public ListDatatype(Datatype listDatatype, QName schemaType) {
        super(BuiltInType.LIST, schemaType);
        this.rcs = listDatatype.getRestrictedCharacterSet();
        if (listDatatype.getBuiltInType() == BuiltInType.LIST) {
            throw new IllegalArgumentException();
        }
        this.listDatatype = listDatatype;
    }

    public Datatype getListDatatype() {
        return this.listDatatype;
    }

    protected boolean isValidString(String value) {
        this.listValues = ListValue.parse(value, this.listDatatype);
        return this.listValues != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof ListValue) {
            ListValue lv = (ListValue)value;
            if (this.listDatatype.getBuiltInType() == lv.getListDatatype().getBuiltInType()) {
                this.listValues = lv;
                return true;
            }
            this.listValues = null;
            return false;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        Value[] values = this.listValues.toValues();
        valueChannel.encodeUnsignedInteger(values.length);
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            boolean valid = this.listDatatype.isValid(v);
            if (!valid) {
                throw new RuntimeException("ListValue is not valid, " + v);
            }
            this.listDatatype.writeValue(encoderContext, qnContext, valueChannel);
            ++n2;
        }
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        int len = valueChannel.decodeUnsignedInteger();
        Value[] values = new Value[len];
        int i = 0;
        while (i < len) {
            values[i] = this.listDatatype.readValue(decoderContext, qnContext, valueChannel);
            ++i;
        }
        return new ListValue(values, this.listDatatype);
    }
}

