/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBase64CharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDHexBinaryCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.charset.XSDStringCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class EnumerationDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -5065239322174326749L;
    protected int codingLength;
    protected Value[] enumValues;
    protected BuiltInType bitEnumValues;
    protected int lastValidIndex;

    public EnumerationDatatype(Value[] enumValues, BuiltInType bitEnumValues, QName schemaType) {
        super(BuiltInType.ENUMERATION, schemaType);
        this.enumValues = enumValues;
        this.bitEnumValues = bitEnumValues;
        this.codingLength = MethodsBag.getCodingLength(enumValues.length);
        switch (bitEnumValues) {
            case BINARY_BASE64: {
                this.rcs = new XSDBase64CharacterSet();
                break;
            }
            case BINARY_HEX: {
                this.rcs = new XSDHexBinaryCharacterSet();
                break;
            }
            case BOOLEAN: {
                this.rcs = new XSDBooleanCharacterSet();
                break;
            }
            case DECIMAL: {
                this.rcs = new XSDDecimalCharacterSet();
                break;
            }
            case FLOAT: {
                this.rcs = new XSDDoubleCharacterSet();
                break;
            }
            case INTEGER: {
                this.rcs = new XSDIntegerCharacterSet();
                break;
            }
            case DATETIME: {
                this.rcs = new XSDDateTimeCharacterSet();
                break;
            }
            default: {
                this.rcs = new XSDStringCharacterSet();
            }
        }
    }

    public int getEnumerationSize() {
        return this.enumValues.length;
    }

    public int getCodingLength() {
        return this.codingLength;
    }

    public boolean isValid(Value value) {
        int index = 0;
        while (index < this.enumValues.length) {
            if (this.enumValues[index].equals(value)) {
                this.lastValidIndex = index;
                return true;
            }
            ++index;
        }
        return false;
    }

    public Value getEnumValue(int i) {
        assert (i >= 0 && i < this.enumValues.length);
        return this.enumValues[i];
    }

    public BuiltInType getEnumValueBuiltInType() {
        return this.bitEnumValues;
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastValidIndex, this.codingLength);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        int index = valueChannel.decodeNBitUnsignedInteger(this.codingLength);
        assert (index >= 0 && index < this.enumValues.length);
        return this.enumValues[index];
    }
}

