/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.DecimalValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class DecimalDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -1045398309238670727L;
    protected DecimalValue lastValidDecimal;

    public DecimalDatatype(QName schemaType) {
        super(BuiltInType.DECIMAL, schemaType);
        this.rcs = new XSDDecimalCharacterSet();
    }

    protected boolean isValidString(String value) {
        this.lastValidDecimal = DecimalValue.parse(value);
        return this.lastValidDecimal != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof DecimalValue) {
            this.lastValidDecimal = (DecimalValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeDecimal(this.lastValidDecimal.isNegative(), this.lastValidDecimal.getIntegral(), this.lastValidDecimal.getRevFractional());
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        return valueChannel.decodeDecimalValue();
    }
}

