/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class BooleanFacetDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = 3601744720431415L;
    private int lastValidBooleanID;
    private boolean lastValidBoolean;

    public BooleanFacetDatatype(QName schemaType) {
        super(BuiltInType.BOOLEAN_FACET, schemaType);
        this.rcs = new XSDBooleanCharacterSet();
    }

    protected boolean isValidString(String value) {
        value = value.trim();
        boolean retValue = true;
        if (value.equals("false")) {
            this.lastValidBooleanID = 0;
            this.lastValidBoolean = false;
        } else if (value.equals("0")) {
            this.lastValidBooleanID = 1;
            this.lastValidBoolean = false;
        } else if (value.equals("true")) {
            this.lastValidBooleanID = 2;
            this.lastValidBoolean = true;
        } else if (value.equals("1")) {
            this.lastValidBooleanID = 3;
            this.lastValidBoolean = true;
        } else {
            retValue = false;
        }
        return retValue;
    }

    public boolean isValid(Value value) {
        if (value instanceof BooleanValue) {
            this.lastValidBoolean = ((BooleanValue)value).toBoolean();
            this.lastValidBooleanID = this.lastValidBoolean ? 2 : 0;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeNBitUnsignedInteger(this.lastValidBooleanID, 2);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        int booleanID = valueChannel.decodeNBitUnsignedInteger(2);
        return new BooleanValue(booleanID);
    }
}

