/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDBooleanCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class BooleanDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -6150310956233103627L;
    protected BooleanValue bool;

    public BooleanDatatype(QName schemaType) {
        super(BuiltInType.BOOLEAN, schemaType);
        this.rcs = new XSDBooleanCharacterSet();
    }

    public boolean isValidString(String value) {
        this.bool = BooleanValue.parse(value);
        return this.bool != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof BooleanValue) {
            this.bool = (BooleanValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public boolean isValidRCS(Value value) {
        super.isValidRCS(value);
        return this.isValid(value);
    }

    public boolean getBoolean() {
        return this.bool.toBoolean();
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeBoolean(this.bool.toBoolean());
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        return valueChannel.decodeBooleanValue();
    }
}

